<!DOCTYPE html>
<html lang="es">
<head>
<meta charset="UTF-8">

<style>
    body {
        font-family: Arial, Helvetica, sans-serif;
        font-size: 12px;
    }

    .header {
        width: 100%;
        margin-bottom: 20px;
    }

    .left {
        float: left;
        width: 60%;
    }

    .right {
        float: right;
        width: 40%;
        text-align: right;
    }

    .clear {
        clear: both;
    }

    table {
        width: 100%;
        border-collapse: collapse;
        margin-top: 15px;
    }

    th, td {
        border: 1px solid #000;
        padding: 6px;
        font-size: 11px;
    }

    th {
        background-color: #e9ecef;
        text-align: center;
    }

    .estado {
        font-weight: bold;
    }

    .footer {
        position: fixed;
        bottom: -10px;
        text-align: center;
        font-size: 10px;
        width: 100%;
    }
</style>
</head>

<body>

<!-- ENCABEZADO -->
<div class="header">
    <div class="left">
        <h2>
            <strong>CÓDIGO DEL PROCESO:</strong>N°
            <?php echo e($proceso->codigo_proceso); ?>

        </h2>
    </div>

    <div class="right">
        <img src="<?php echo e(public_path('assets/images/logo.png')); ?>" width="250">
    </div>
</div>

<div class="clear"></div>
<hr>

<!-- DATOS GENERALES -->
<p><strong>Proceso:</strong> <?php echo e($proceso->nombre_proceso); ?></p>
<p><strong>Nurej:</strong> <?php echo e($proceso->numero_nurej); ?></p>
<p><strong>Parte demandante:</strong> <?php echo e($proceso->parte_demandante); ?></p>
<p><strong>Fecha de registro:</strong> <?php echo e($proceso->created_at->format('d/m/Y')); ?></p>

<hr>

<!-- TABLA DE SEGUIMIENTOS -->
<h4>Historial de Seguimiento</h4>

<table>
    <thead>
        <tr>
            <th>#</th>
            <th>Fecha</th>
            <th>Estado</th>
            <th>Observación</th>
            <th>Registrado por</th>
        </tr>
    </thead>

    <tbody>
        <?php $__currentLoopData = $proceso->seguimientos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $seg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <tr>
            <td align="center"><?php echo e($i+1); ?></td>
            <td><?php echo e(date('d/m/Y', strtotime($seg->fecha_seguimiento))); ?></td>
            <td align="center"><?php echo e($seg->estado->nombre); ?></td>
            <td><?php echo e($seg->observacion); ?></td>
            <td><?php echo e($seg->usuario->name ?? '—'); ?></td>
        </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

<h4>Audiencias Registradas</h4>

<table>
    <thead>
            <th>#</th>
            <th>Fecha</th>
            <th>Hora</th>
            <th>Lugar</th>
            <th>Juzgado</th>
            <th>Sala</th>
            <th>Departamento</th>
            <th>Estado</th>
            <th>Responsable(s)</th>
        </thead>
        <tbody>
            <?php $__currentLoopData = $proceso->audiencias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $j => $audiencia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td align="center"><?php echo e($j+1); ?></td>
                <td align="center"><?php echo e(date('d/m/Y', strtotime($audiencia->fecha_audiencia))); ?></td>
                <td align="center"><?php echo e(date('h:i A', strtotime($audiencia->hora_audiencia))); ?></td>
                <td><?php echo e($audiencia->lugar); ?></td>
                <td><?php echo e($audiencia->juzgado); ?></td>
                <td><?php echo e($audiencia->sala); ?></td>
                <td><?php echo e($audiencia->departamento); ?></td>
                <td align="center"><?php echo e($audiencia->estado->nombre); ?></td>
                <td>
                    <?php $__currentLoopData = $audiencia->abogados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $abogado): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <span class="badge bg-primary"><?php echo e($abogado->name); ?></span>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
<hr>
<div class="footer">
    Documento generado automáticamente — Dirección Jurídica
</div>

</body>
</html>
<?php /**PATH C:\laragon\www\procesosjudiciales\resources\views/seguimientos/show.blade.php ENDPATH**/ ?>