<?php if($proceso->seguimientos->isNotEmpty()): ?>
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex align-items-center justify-content-between">
                    Seguimientos del Proceso
                    <?php if($proceso->seguimientos->count() > 1): ?>
                        <a href="<?php echo e(route('seguimientos.ver_adjuntos',$proceso)); ?>" target="_blank">Ver Todos los Adjuntos</a>
                    <?php endif; ?>
                </div>
            </div>
            <div class="card-body">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th class="text-center"></th>
                            <th class="text-center">Fecha</th>
                            <th class="text-center">Estado</th>
                            <th class="text-center">Observación</th>
                            <th class="text-center">Adjunto</th>
                            <th class="text-center">Registrado Por</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $proceso->seguimientos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                            <td class="text-center">
                                <div class="btn-group btn-group-sm" role="group">
                                    <button id="btnAcciones<?php echo e($s->id); ?>" type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        Acciones
                                    </button>
                                    <ul class="dropdown-menu" aria-labelledby="btnAcciones<?php echo e($s->id); ?>">     
                                        <li><a class="dropdown-item" href="<?php echo e(route('seguimientos.edit', $s)); ?>">Editar</a></li>
                                        <li><a href="<?php echo e(route('seguimientos.destroy', $s->id)); ?>" class="dropdown-item" data-confirm-delete="true">Eliminar</a></li>
                                    </ul>
                                </div>
                            </td>
                            <td class="text-center"><?php echo e(date('d/m/Y', strtotime($s->fecha_seguimiento))); ?></td>
                            <td class="text-center"><?php echo e($s->estado->nombre); ?></td>
                            <td><?php echo e($s->observacion); ?></td>
                            <td class="text-center">
                                <?php if($s->adjunto): ?>
                                    <a href="<?php echo e(asset('/seguimientos/' . $s->adjunto)); ?>" target="_blank">Ver Adjunto</a>
                                <?php else: ?>
                                    No hay adjunto
                                <?php endif; ?>
                            </td>
                            <td class="text-center"><?php echo e($s->usuario->name); ?></td>
                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php endif; ?><?php /**PATH C:\laragon\www\procesosjudiciales\resources\views/seguimientos/_seguimientos_proceso.blade.php ENDPATH**/ ?>