@extends('layouts.app')
@section('title', 'Seguimientos Registrados')
@section('content')
<div class="row">
    <div class="col-md-12 grid-margin stretch-card">
        <div class="card">
            <div class="card-body performane-indicator-card">
                <h4 class="card-title">Seguimientos Registrados</h4>
                <table class="table">
                    <thead>
                        <tr>
                            <th class="text-center">Fecha</th>
                            <th class="text-center">Proceso</th>
                            <th class="text-center">Estado</th>
                            <th class="text-center">Observación</th>
                            <th class="text-center">Registrado Por</th>
                            <th class="text-center">Adjunto</th>

                        </tr>
                    </thead>
                    <tbody>
                        @foreach($seguimientos as $s)
                        <tr>
                            <td>{{ date('d/m/Y', strtotime($s->fecha_seguimiento)) }}</td>
                            <td class="text-center">{{ $s->proceso->codigo_proceso }}</td>
                            <td class="text-center">{{ $s->estado->nombre }}</td>
                            <td>{{ $s->observacion }}</td>
                            <td>{{ $s->usuario->name }}</td>
                            <td class="text-center">
                                @if($s->adjunto)
                                    <a href="{{ asset('storage/seguimientos/' . $s->adjunto) }}" target="_blank">Ver Adjunto</a>
                                @else
                                    No hay adjunto
                                @endif
                            </td>
                        </tr>
                        @endforeach

                    </tbody>
                    </table>

            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
@endsection