@if($proceso->seguimientos->isNotEmpty())
<div class="row">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex align-items-center justify-content-between">
                    Seguimientos del Proceso
                    @if($proceso->seguimientos->count() > 1)
                        <a href="{{ route('seguimientos.ver_adjuntos',$proceso) }}" target="_blank">Ver Todos los Adjuntos</a>
                    @endif
                </div>
            </div>
            <div class="card-body">
                <table class="table table-sm">
                    <thead>
                        <tr>
                            <th class="text-center"></th>
                            <th class="text-center">Fecha</th>
                            <th class="text-center">Estado</th>
                            <th class="text-center">Observación</th>
                            <th class="text-center">Adjunto</th>
                            <th class="text-center">Registrado Por</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($proceso->seguimientos as $s)
                        <tr>
                            <td class="text-center">
                                <div class="btn-group btn-group-sm" role="group">
                                    <button id="btnAcciones{{ $s->id }}" type="button" class="btn btn-primary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                                        Acciones
                                    </button>
                                    <ul class="dropdown-menu" aria-labelledby="btnAcciones{{ $s->id }}">     
                                        <li><a class="dropdown-item" href="{{ route('seguimientos.edit', $s) }}">Editar</a></li>
                                        <li><a href="{{ route('seguimientos.destroy', $s->id) }}" class="dropdown-item" data-confirm-delete="true">Eliminar</a></li>
                                    </ul>
                                </div>
                            </td>
                            <td class="text-center">{{ date('d/m/Y', strtotime($s->fecha_seguimiento)) }}</td>
                            <td class="text-center">{{ $s->estado->nombre }}</td>
                            <td>{{ $s->observacion }}</td>
                            <td class="text-center">
                                @if($s->adjunto)
                                    <a href="{{ asset('/seguimientos/' . $s->adjunto) }}" target="_blank">Ver Adjunto</a>
                                @else
                                    No hay adjunto
                                @endif
                            </td>
                            <td class="text-center">{{ $s->usuario->name }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endif