<p>Debe rellenar todos los campos marcados con <strong class="text-danger">(*)</strong>.
    Al momento de registrar/editar un usuario, debe asignarle un rol, para que pueda solo ver y administrar la información que corresponda</p>
@if ($errors->any())
    <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
    <ul class="list-ticked mensaje-error">
        @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
        @endforeach
    </ul>
@endif

<div class="row mb-1 ">
    <label for="role_id" class="col-md-4 col-form-label text-right">Rol <span class="text-danger">(*)</span></label>
    <div class="col-md-6 mb-0 pb-0">
        <select name="role_id"  class="form-control form-control-lg {{ $errors->has('role_id') ? ' is-invalid' : '' }}" id="role_id" onchange="changeRol(this)">
            <option value="">--SELECCIONE--</option>
            @foreach($roles as $rol)
                @if($rol->id != 1)
                    <option value="{{$rol->id}}" {{ old('role_id',$user->rol != null ? $user->rol[0]->id :'')== $rol->id ? 'selected' : '' }}>{{$rol->name}} <em>({{$rol->descripcion}})</em></option>
                @endif
            @endforeach
        </select>
    </div>
</div>

<div class="row mb-1 ">
    <label for="name" class="col-md-4 col-form-label text-right">Nombre Completo <span class="text-danger">(*)</span></label>
    <div class="col-md-6">
        <input id="name" type="text" class="form-control {{ $errors->has('name') ? ' is-invalid' : '' }}" name="name" value="{{ old('name',$user->name) }}"  autofocus onkeyup="javascript:this.value=this.value.toUpperCase();" >
    </div>
</div>
<div class="row mb-1 ">
    <label for="username" class="col-md-4 col-form-label text-right">Nombre de Usuario <span class="text-danger">(*)</span></label>
    <div class="col-md-6">
        <input id="username" type="text" class="form-control {{ $errors->has('username') ? ' is-invalid' : '' }}" name="username" value="{{ old('username',$user->username) }}" >
    </div>
</div>
<div class="row mb-1 ">
    <label for="email" class="col-md-4 col-form-label text-right ">Correo <span class="text-danger">(*)</span></label>
    <div class="col-md-6">
        <input id="email" type="email" class="form-control{{ $errors->has('email') ? ' is-invalid' : '' }}" name="email" value="{{ old('email',$user->email) }}">
    </div>
</div>

<div class="row mb-0 ">
    <label for="password" class="col-md-4 col-form-label text-right ">{{ $texto_pass }} @if($tipo==1) <span class="text-danger">(*)</span> @endif</label>

    <div class="col-md-6">
        <input id="password" type="password" class="form-control @error('password') is-invalid @enderror" name="password" autocomplete="new-password">
    </div>
</div>
@if($tipo==1)
    <div class="row mt-1">
        <label for="password-confirm" class="col-md-4 col-form-label text-right ">{{ __('Confirm Password') }} <span class="text-danger">(*)</span></label>
        <div class="col-md-6">
            <input id="password-confirm" type="password" class="form-control" name="password_confirmation" >
        </div>
    </div>
@endif
<div class="text-center mt-3">
    <button type="submit" class="btn btn-{{ $color }}">{{ $texto }}</button>
    <a href="{{ route('users.index') }}" class="btn btn-warning">Salir</a>
</div>