
@extends('layouts.app')
@section('title','Roles')
@section('content')

<div class="main-content-inner">
    <div class="row">
        <div class="col-xl-9 col-lg-8">
            <div class="card">
                <div class="card-header">
                    <h4>Listado de roles habilitados</h4>
                    @can('roles.create')
                        <a href="{{ route('roles.create') }}" class="btn btn-primary btn-round">Agregar Nuevo</a>
                    @endif
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                    <table class="table table-hover table-sm">
                        <thead>
                            <tr>
                                <th class="text-center" >Acciones</th>
                                <th class="text-center">Rol</th>
                                <th class="text-center ">Descripción</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($roles as $role)
                                <tr>
                                    <td>
                                        <div class="d-flex justify-content-center">
                                            @can('roles.show')
                                                <a href="{{route('roles.show',$role->id)}}" ><button class="btn btn-secondary btn-icon btn-sm" title="Ver los permisos asignados al rol">Ver</button></a>
                                            @endcan
                                            @can('roles.edit')
                                                <a href="{{route('roles.edit',$role->id)}}"  ><button class="btn btn-warning btn-icon btn-sm" title="Modificar Permisos asignados al rol">Editar</button></a>
                                            @endcan
                                            @can('roles.destroy')
                                                {!! Form::open(['route'=>['roles.destroy',$role->id],'method'=>'DELETE']) !!}
                                                    <button class="btn btn-danger btn-icon btn-sm " data-toggle="tooltip" data-placement="top" title="Eliminar rol" onclick="return confirm('¿Está seguro que desea eliminar el rol?');">Eliminar</button>
                                                {!! Form::close() !!}
                                            @endcan
                                        </div>
                                    </td>
                                    <td class="fw-bold">{{$role->name}}</td>
                                    <td class="text-wrap">{{$role->descripcion}}</td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection