<p>Debe rellenar todos los campos.</p>
@if ($errors->any())
    <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
    <ul class="list-ticked mensaje-error">
        @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
        @endforeach
    </ul>
@endif
<div class="form-group row {{ $errors->has('name') ? 'has-error' : '' }}">
        <label for="name" class="col-lg-3 col-md-3 col-xs-12 col-form-label text-right ">Nombre rol<span class="text-danger text-bold">(*)</span></label>
    <div class="col-lg-7 col-md-7 col-xs-12">
        <input type="text" class="form-control @error('name') error @enderror" name="name" id="name" value="{{ old('name',$role->name) }}">
    </div>
</div>

<div class="form-group row {{ $errors->has('descripcion') ? 'has-error' : '' }}">
    <label for="descripcion" class="col-lg-3 col-md-3 col-xs-12 col-form-label text-right">Descripción<span class="text-danger text-bold">(*)</span></label>
    <div class="col-lg-9 col-md-9 col-xs-12">
        <input type="text" class="form-control @error('descripcion') error @enderror" name="descripcion" id=descripcion value="{{ old('descripcion',$role->descripcion) }}">
    </div>
</div>

<hr>
<h3 >Lista de Permisos</h3>
<p class="mb-0">Los permisos se encuentran agrupados por cada sección del intranet, solo debe presionar sobre el nombre del grupo para abrir el contenido del grupo y escoger los permisos que quiere asignar.</p>
<p>Marque los permisos que quiere asignar al Rol y luego presione el boton <strong>GUARDAR</strong></p>
<!-- Accordion without outline borders -->
<div class="row mb-3">
    <div class="col-md-6">
        <div class="accordion" id="accordionPanelsStayOpenExample">
            @foreach($grupos as $cont_grupo=>$grupo)
            <div class="accordion-item">   
                <h2 class="accordion-header" id="panelsStayOpen-headingOne"> 
                <button class="accordion-button colla collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne-{{ $cont_grupo }}" aria-controls="collapseOne-{{ $cont_grupo }}" aria-expanded="false">
                    {{ $grupo->grupo }} 
                    <div class="badge badge-warning" id="contador-{{ $cont_grupo }}" style="font-size: 1rem; color: #000;"></div>
                </button>
                </h2>
                <div id="collapseOne-{{ $cont_grupo }}" class="collapse">
                    <div class="accordion-body">
                        <div class="form-check pb-0 pt-0">
                            <label class="form-check-label">
                                {{ Form::checkbox('marcar_todo_'.$grupo->grupo, null, false, ['class' => 'form-check-input marcar-todos', 'data-grupo' => $cont_grupo]) }}
                                <span class="form-check-sign">MARCAR / DESMARCAR TODOS</span>
                            </label>
                        </div>
                        <?php $cont=0; ?>
                        @foreach($permissions as $permission)
                            @if($permission->grupo==$grupo->grupo)
                            <?php $cont=$cont+1; ?>
                            <div class="form-check pb-0 pt-0">
                                <label class="form-check-label">
                                    {{ Form::checkbox('permissions[]', $permission->id, null, ['class' => 'form-check-input permission-checkbox', 'id' => 'basic_checkbox_' . $cont, 'data-grupo' => $cont_grupo]) }}
                                    <span class="form-check-sign">{{$permission->descripcion ?: 'Sin descripción'}} <em>({{$permission->name}})</em></span>
                                </label>
                            </div>
                            @endif
                        @endforeach
                    </div> 
                </div>
            </div>
            @endforeach
        </div>
    </div>
    <div class="col-md-6">
        <h2>Permisos asignados</h2>
        <ul class="list-unstyled">
            @forelse($role->permissions as $permission)
            <li>
                <label>
                    <strong>{{$permission->descripcion ?: 'Sin descripción'}}</strong>
                </label>
            </li>
            @empty
            <li>
                <label>
                    Sin Permisos Asignados
                </label>
            </li>
            @endforelse
        </ul>
    </div>
</div>
<div class="text-center">
    {{ Form::submit('Guardar',['class'=>'btn btn-primary btn-round']) }}
    <a href="javascript:history.back()" class="btn btn-warning btn-round">Cancelar</a>
</div>
