@extends('layouts.app')
@section('title','Gestión de Perfiles y Permisos')
@section('content')

<div class="page-title-area mb-3">
    <div class="row align-items-center">
        <div class="col-sm-6">
            <div class="breadcrumbs-area clearfix">
                <h4 class="page-title pull-left">Gestión de Perfiles y Permisos</h4>
                <ul class="breadcrumbs pull-left">
                    <li><a href="{{ route('home') }}">Dashboard</a></li>
                    <li><span>Gestión de Perfiles y Permisos</span></li>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="main-content-inner">
    <div class="row">
        <div class="col-xl-9 col-lg-8">
            <div class="card">
                <div class="card-body">
                    <form action="{{ route('perfil.permisos.guardar') }}" method="POST">
                        @csrf
                        <div class="row">
                            <label for="rol" class="form-label col-md-4 text-md-right">Selecciona un perfil:</label>
                            <div class="col-md-8">
                                <select name="rol" id="rol" class="form-control form-control-lg">
                                    <option value="">-- Selecciona --</option>
                                    @foreach ($perfiles as $rol)
                                        <option value="{{ $rol->name }}">{{ $rol->name }}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>
                    
                        <div id="tablaPermisos" style="display: none; margin-top: 20px;">
                            <div class="d-flex align-items-center justify-content-between" >
                                <h3 id="tituloRol"></h3>
                                <div>
                                    <button type="button" id="seleccionar-todos" class="btn btn-warning">Seleccionar todos</button>
                                    <button type="button" id="deseleccionar-todos" class="btn btn-secondary">Deseleccionar todos</button>
                                </div>
                            </div>
                            <br>
                            <table  cellpadding="6" cellspacing="0" class="table table-hover table-sm table-bordered">
                                <thead> 
                                    <tr>
                                        <th class="text-center">Formulario</th>
                                        <th class="text-center">Registrar</th>
                                        <th class="text-center">Editar</th>
                                        <th class="text-center">Eliminar</th>
                                        <th class="text-center">Aprobar</th>
                                        <th class="text-center">Visualización</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($formularios as $formulario)
                                        <tr>
                                            <td>{{ $formulario->nombre }}</td>
                                            @foreach (['registrar', 'editar', 'eliminar', 'aprobar','ver'] as $accion)
                                                <td style="text-align:center;">
                                                    <input type="checkbox"
                                                        name="permisos[{{ $formulario->idpar_tipoformulario }}][{{ $accion }}]"
                                                        value="1"
                                                        class="permiso-checkbox"
                                                        data-permiso="{{ $accion . '_formulario_' . $formulario->idpar_tipoformulario }}">
                                                </td>
                                            @endforeach
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                    
                            <input type="hidden" name="rolSeleccionado" id="rolSeleccionado">
                            <div class="text-center">
                                <button type="submit" style="margin-top: 10px;" class="btn btn-primary">Guardar permisos</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
    document.getElementById('rol').addEventListener('change', function () {
        const rol = this.value;

        if (!rol) {
            document.getElementById('tablaPermisos').style.display = 'none';
            return;
        }

        fetch(url_global + `/perfiles-permisos/permisos?rol=${rol}`)
            .then(response => response.json())
            .then(permisos => {
                // Desmarca todos primero
                document.querySelectorAll('.permiso-checkbox').forEach(checkbox => {
                    checkbox.checked = false;
                });

                // Marca los permisos que tiene el rol
                permisos.forEach(nombre => {
                    const checkbox = document.querySelector(`.permiso-checkbox[data-permiso="${nombre}"]`);
                    if (checkbox) {
                        checkbox.checked = true;
                    }
                });

                document.getElementById('rolSeleccionado').value = rol;
                document.getElementById('tituloRol').innerText = `Permisos asignados a: ${rol}`;
                document.getElementById('tablaPermisos').style.display = 'block';
            });
    });
    $('#seleccionar-todos').on('click', function () {
        $('.permiso-checkbox').prop('checked', true);
    });

    $('#deseleccionar-todos').on('click', function () {
        $('.permiso-checkbox').prop('checked', false);
    });

</script>
@endsection