<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;

class PermissionsTableSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        // // // Usuarios
        Permission::create(['descripcion'=>'Ver todos los usuarios','name'=>'users.index','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Registar nuevos usuarios','name'=>'users.create','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Ver perfil de usuario','name'=>'users.show','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Edición de usuarios','name'=>'users.edit','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Eliminar usuario','name'=>'users.destroy','grupo'=>'01 - Administración']);

        // // //Roles
        Permission::create(['descripcion'=>'Ver todos los roles','name'=>'roles.index','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Ver detalle de rol','name'=>'roles.show','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Creación de roles','name'=>'roles.create','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Edición de roles','name'=>'roles.edit','grupo'=>'01 - Administración']);
        Permission::create(['descripcion'=>'Eliminar rol','name'=>'roles.destroy','grupo'=>'01 - Administración']);
        
        // // //Permisos
        // Permission::create(['descripcion'=>'Ver todos los permisos','name'=>'permisos.index','grupo'=>'01 - Administración']);
        // Permission::create(['descripcion'=>'Ver detalle de permiso','name'=>'permisos.show','grupo'=>'01 - Administración']);
        // Permission::create(['descripcion'=>'Creación de permisos','name'=>'permisos.create','grupo'=>'01 - Administración']);
        // Permission::create(['descripcion'=>'Edición de permisos','name'=>'permisos.edit','grupo'=>'01 - Administración']);
        // Permission::create(['descripcion'=>'Eliminar permiso','name'=>'permisos.destroy','grupo'=>'01 - Administración']);
        // Permission::create(['descripcion'=>'Administración del manual del usuario','name'=>'manual.admin','grupo'=>'01 - Administración']);

        // //parametros
        Permission::create(['descripcion'=>'Ver todos los parámetros','name'=>'parametros.index','grupo'=>'02 - Parámetros']);
        Permission::create(['descripcion'=>'Registrar nuevos parámetros','name'=>'parametros.create','grupo'=>'02 - Parámetros']);
        Permission::create(['descripcion'=>'Ver detalle de parámetro','name'=>'parametros.show','grupo'=>'02 - Parámetros']);
        Permission::create(['descripcion'=>'Edición de parámetros','name'=>'parametros.edit','grupo'=>'02 - Parámetros']);
        Permission::create(['descripcion'=>'Eliminar parámetro','name'=>'parametros.destroy','grupo'=>'02 - Parámetros']);

        //Asignaciones
        Permission::create(['descripcion'=>'Ver todas las asignaciones','name'=>'asignaciones.index','grupo'=>'04 - Asignaciones']);
        Permission::create(['descripcion'=>'Registrar nueva asignación','name'=>'asignaciones.create','grupo'=>'04 - Asignaciones']);
        Permission::create(['descripcion'=>'Ver detalle de asignación','name'=>'asignaciones.show','grupo'=>'04 - Asignaciones']);
        Permission::create(['descripcion'=>'Edición de asignación','name'=>'asignaciones.edit','grupo'=>'04 - Asignaciones']);
        Permission::create(['descripcion'=>'Eliminar asignación','name'=>'asignaciones.destroy','grupo'=>'04 - Asignaciones']);

        //Seguimientos
        Permission::create(['descripcion'=>'Ver todos los seguimientos','name'=>'seguimientos.index','grupo'=>'05 - Seguimientos']);
        Permission::create(['descripcion'=>'Registrar nuevo seguimiento','name'=>'seguimientos.create','grupo'=>'05 - Seguimientos']);
        Permission::create(['descripcion'=>'Ver detalle de seguimiento','name'=>'seguimientos.show','grupo'=>'05 - Seguimientos']);
        Permission::create(['descripcion'=>'Edición de seguimiento','name'=>'seguimientos.edit','grupo'=>'05 - Seguimientos']);
        Permission::create(['descripcion'=>'Eliminar seguimiento','name'=>'seguimientos.destroy','grupo'=>'05 - Seguimientos']);

        //Procesos
        Permission::create(['descripcion'=>'Ver todos los procesos judiciales','name'=>'procesos.index','grupo'=>'06 - Procesos Judiciales']);
        Permission::create(['descripcion'=>'Registrar nuevo proceso judicial','name'=>'procesos.create','grupo'=>'06 - Procesos Judiciales']);
        Permission::create(['descripcion'=>'Ver detalle de proceso judicial','name'=>'procesos.show','grupo'=>'06 - Procesos Judiciales']);
        Permission::create(['descripcion'=>'Edición de proceso judicial','name'=>'procesos.edit','grupo'=>'06 - Procesos Judiciales']);
        Permission::create(['descripcion'=>'Eliminar proceso judicial','name'=>'procesos.destroy','grupo'=>'06 - Procesos Judiciales']);

        //Audiencias
        Permission::create(['descripcion'=>'Ver todas las audiencias','name'=>'audiencias.index','grupo'=>'07 - Audiencias']);
        Permission::create(['descripcion'=>'Registrar nueva audiencia','name'=>'audiencias.create','grupo'=>'07 - Audiencias']);
        Permission::create(['descripcion'=>'Ver detalle de audiencia','name'=>'audiencias.show','grupo'=>'07 - Audiencias']);
        Permission::create(['descripcion'=>'Edición de audiencia','name'=>'audiencias.edit','grupo'=>'07 - Audiencias']);
        Permission::create(['descripcion'=>'Eliminar audiencia','name'=>'audiencias.destroy','grupo'=>'07 - Audiencias']);

        //Requerimientos
        Permission::create(['descripcion'=>'Ver todos los requerimientos','name'=>'requerimientos.index','grupo'=>'08 - Requerimientos']);
        Permission::create(['descripcion'=>'Registrar nuevo requerimiento','name'=>'requerimientos.create','grupo'=>'08 - Requerimientos']);
        Permission::create(['descripcion'=>'Ver detalle de requerimiento','name'=>'requerimientos.show','grupo'=>'08 - Requerimientos']);
        Permission::create(['descripcion'=>'Edición de requerimiento','name'=>'requerimientos.edit','grupo'=>'08 - Requerimientos']);
        Permission::create(['descripcion'=>'Eliminar requerimiento','name'=>'requerimientos.destroy','grupo'=>'08 - Requerimientos']);

    }
}
