<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;

class AudienciaRecordatorioNotification extends Notification
{
    use Queueable;

    protected $audiencia;
    public function __construct($audiencia)
    {
        $this->audiencia = $audiencia;
    }

    public function via(object $notifiable): array
    {
        return ['mail'];
    }

    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('📅 Recordatorio de Audiencia Judicial')
            ->greeting('Estimado/a '.$notifiable->name)
            ->line('Se le recuerda que tiene programada la siguiente audiencia:')
            ->line('Proceso: '.$this->audiencia->nro_proceso)
            ->line('Tipo: '.$this->audiencia->tipo_audiencia->nombre)
            ->line('Fecha: '.date('d/m/Y', strtotime($this->audiencia->fecha_audiencia)))
            ->line('Hora: '.$this->audiencia->hora_audiencia)
            ->line('Juzgado: '.$this->audiencia->juzgado)
            // ->action('Ver detalle de la audiencia', url('/audiencias/'.$this->audiencia->id))
            ->line('Gerencia Jurídica');
    }

    public function toArray(object $notifiable): array
    {
        return [
            //
        ];
    }
}
