<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use OwenIt\Auditing\Contracts\Auditable;
use Mattiverse\Userstamps\Traits\Userstamps;
use Illuminate\Database\Eloquent\SoftDeletes;

class Proceso extends Model implements Auditable
{
    use \OwenIt\Auditing\Auditable;
    use SoftDeletes, Userstamps;

    protected $fillable = [
        'numero_nurej',
        'parte_demandante',
        'nombre_proceso',
        'tipo_proceso_id',
        'fecha_inicio',
        'observaciones','delito'
    ];
    protected static function booted()
    {
        static::creating(function ($proceso) {
            
            $tipo = $proceso->tipo_proceso()->first();
            $gestion_proceso=date('Y', strtotime($proceso->fecha_inicio));

            // Calcular el número incremental para esa gestión
            $ultimo = self::withTrashed()->whereYear('fecha_inicio', $gestion_proceso)
                ->max('numero_proceso');

            $nro = $ultimo ? $ultimo + 1 : 1;
            $proceso->numero_proceso = $nro;

            // Formato con ceros: 001, 002, ...
            $codigo = sprintf(
                "SEDEM/GJ/%s/%d-%03d",
                $tipo->codigo, // Igual que arriba
                $gestion_proceso,
                $nro
            );
            $proceso->codigo_proceso = $codigo;
        });
    }

    public function tipo_proceso()
    {
        return $this->belongsTo(Parametro::class, 'tipo_proceso_id', 'id');
    }

    public function seguimientos()
    {
        return $this->hasMany(Seguimiento::class, 'proceso_id');
    }

    public function audiencias()
    {
        return $this->hasMany(Audiencia::class, 'proceso_id');
    }
}
