<?php

namespace App\Http\Controllers;

use App\Models\Proceso;
use setasign\Fpdi\Fpdi;
use App\Models\Parametro;
use App\Models\Seguimiento;
use Illuminate\Http\Request;
use Barryvdh\Snappy\Facades\SnappyPdf;
use RealRashid\SweetAlert\Facades\Alert;
use setasign\Fpdi\PdfParser\StreamReader;

class SeguimientoController extends Controller
{
    public function index()
    {
        $seguimientos = Seguimiento::with('proceso','usuario')
            ->latest()->paginate(15);

        return view('seguimientos.index', compact('seguimientos'));
    }

    public function create(Proceso $proceso)
    {
        $estados_proceso=Parametro::where('tipo','ESTADO_PROCESO')->get();
        $seguimientos=Seguimiento::where('proceso_id',$proceso->id)->orderBy('fecha_seguimiento','desc')->get();
        return view('seguimientos.create', compact('proceso','estados_proceso','seguimientos'));
    }

    public function store(Request $request)
    {
        $seguimiento=Seguimiento::create([
            'proceso_id' => $request->proceso_id,
            'fecha_seguimiento' => $request->fecha_seguimiento,
            'estado_id' => $request->estado,
            'observacion' => $request->observacion
        ]);

        if($seguimiento){
            $adjunto=$request->file('adjunto');
            if($adjunto) {
                $path=public_path().'/seguimientos/';
                $filename=uniqid().'.'.$adjunto->getClientOriginalExtension();
                $adjunto->move($path, $filename);
                $seguimiento->adjunto=$filename;
                $seguimiento->save();
            }
        }
        $proceso=Proceso::find($request->proceso_id);
        if($request->estado_id==14){ // FINALIZADA
            $proceso->estado=false;
            $proceso->save();
        }
        Alert::success('Éxito', 'Seguimiento registrado');
        return redirect()->route('seguimientos.create',[$proceso->id]);
    }

    public function show(Seguimiento $seguimiento)
    {
        //
    }

    public function edit(Seguimiento $seguimiento)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, Seguimiento $seguimiento)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Seguimiento $seguimiento)
    {
        //
    }

    public function ver_adjuntos(Proceso $proceso)
    {
        $seguimientos=Seguimiento::where('proceso_id',$proceso->id)->get();
        $proceso = Proceso::with(['seguimientos','audiencias'])->findOrFail($proceso->id);

        // 1. PDF base
        $pdfBase = SnappyPdf::loadView('seguimientos.show', compact('proceso'))
            ->setOption('enable-local-file-access', true)
            ->setOption('load-error-handling', 'ignore')
            ->output();

        $pdf = new Fpdi();

        // 2. Importar PDF base desde memoria
        $pageCount = $pdf->setSourceFile(StreamReader::createByString($pdfBase));
        for ($i = 1; $i <= $pageCount; $i++) {
            $tpl = $pdf->importPage($i);
            $size = $pdf->getTemplateSize($tpl);
            $pdf->AddPage($size['orientation'], [$size['width'], $size['height']]);
            $pdf->useTemplate($tpl);
        }

        // 3. Adjuntos PDF
        foreach ($proceso->seguimientos as $seguimiento) {
                $ruta = public_path('seguimientos/' . $seguimiento->adjunto);

                if (file_exists($ruta) && strtolower(pathinfo($ruta, PATHINFO_EXTENSION)) === 'pdf') {
                    $pages = $pdf->setSourceFile($ruta);
                    for ($p = 1; $p <= $pages; $p++) {
                        $tpl = $pdf->importPage($p);
                        $size = $pdf->getTemplateSize($tpl);
                        $pdf->AddPage($size['orientation'], [$size['width'], $size['height']]);
                        $pdf->useTemplate($tpl);
                    }
                }
        }

        return response($pdf->Output('S'), 200, [
            'Content-Type' => 'application/pdf',
            'Content-Disposition' => 'inline; filename="Proceso_'.$proceso->id.'.pdf"',
        ]);
    }
}
