<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use App\Models\Audiencia;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('home');
    }

    public function audienciasCalendar()
    {
        $hoy = Carbon::today();

        $audiencias = Audiencia::where('abogado_id', Auth::id())
            ->get()
            ->map(function ($a) use ($hoy) {

                $fecha = Carbon::parse($a->fecha_audiencia);
                $dias = $hoy->diffInDays($fecha, false);

                if ($a->estado == 'CONCLUIDA') {
                    $color = '#28a745'; // verde
                } elseif ($a->estado == 'SUSPENDIDA') {
                    $color = '#6c757d'; // gris
                } elseif ($dias == 0) {
                    $color = '#dc3545'; // rojo
                } elseif ($dias <= 3) {
                    $color = '#fd7e14'; // naranja
                } elseif ($dias <= 7) {
                    $color = '#ffc107'; // amarillo
                } else {
                    $color = '#0d6efd'; // azul
                }

                return [
                    'id' => $a->id,
                    'title' => $a->tipo_audiencia,
                    'start' => $a->fecha_audiencia.'T'.$a->hora_audiencia,
                    'backgroundColor' => $color,
                    'borderColor' => $color,
                    'extendedProps' => [
                        'proceso' => $a->codigo_proceso,
                        'juzgado' => $a->juzgado,
                        'estado' => ucfirst($a->estado->nombre),
                    ]
                ];
            });

        return response()->json($audiencias);
    }
}
