<?php

namespace App\Exports;

use App\Models\Audiencia;
use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\{
    FromCollection,
    WithHeadings,
    WithStyles,
    WithMapping
};
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;

class AudienciasExport implements FromCollection, WithHeadings, WithMapping, WithStyles
{
    public function collection()
    {
        return Audiencia::with('abogado')
            ->orderBy('fecha_audiencia')
            ->get();
    }

    public function headings(): array
    {
        return [
            'Nro Proceso',
            'Departamento',
            'Tipo Audiencia',
            'Fecha',
            'Hora',
            'Lugar',
            'Caso',
            'Juzgado',
            'Sala',
            'Delito',
            'Parte Contraria',
            'Abogado',
            'Estado',
            'Observaciones',
            'Aviso'
        ];
    }

    public function map($a): array
    {
        $dias = Carbon::now()->diffInDays($a->fecha_audiencia, false);

        if ($a->estado === 'concluida') {
            $aviso = 'Concluida';
        } elseif ($dias <= 0) {
            $aviso = 'HOY / VENCIDA';
        } elseif ($dias <= 3) {
            $aviso = 'URGENTE (≤3 días)';
        } elseif ($dias <= 7) {
            $aviso = 'PRÓXIMA (≤7 días)';
        } else {
            $aviso = 'PROGRAMADA';
        }

        return [
            $a->nro_proceso,
            $a->departamento,
            $a->tipo_audiencia,
            Carbon::parse($a->fecha_audiencia)->format('d/m/Y'),
            $a->hora_audiencia,
            $a->lugar,
            $a->caso,
            $a->juzgado,
            $a->sala,
            $a->delito,
            $a->parte_contraria,
            optional($a->abogado)->name,
            ucfirst($a->estado),
            $a->observaciones,
            $aviso
        ];
    }

    public function styles(Worksheet $sheet)
    {
        $audiencias = $this->collection();

        foreach ($audiencias as $index => $a) {

            $row = $index + 2; // encabezado en fila 1
            $dias = Carbon::now()->diffInDays($a->fecha_audiencia, false);

            if ($a->estado === 'concluida') {
                $color = 'C6EFCE'; // verde
            } elseif ($dias <= 0) {
                $color = 'FFC7CE'; // rojo
            } elseif ($dias <= 3) {
                $color = 'FFD966'; // naranja
            } elseif ($dias <= 7) {
                $color = 'FFF2CC'; // amarillo
            } else {
                $color = 'D9E1F2'; // azul
            }

            $sheet->getStyle("A{$row}:O{$row}")
                ->getFill()
                ->setFillType('solid')
                ->getStartColor()
                ->setARGB($color);
        }

        // Estilo encabezados
        $sheet->getStyle('A1:O1')->applyFromArray([
            'font' => ['bold' => true],
            'fill' => [
                'fillType' => 'solid',
                'startColor' => ['argb' => 'BDD7EE']
            ]
        ]);
    }
}
