<?php

namespace App\Console\Commands;

use App\Models\Audiencia;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Notification;
use App\Notifications\AudienciaRecordatorioNotification;

class RecordatorioAudiencias extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'app:recordatorio-audiencias';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description';

    /**
     * Execute the console command.
     */
    public function handle()
    {
        $audiencias = Audiencia::where('estado_id',9)
            ->whereDate('fecha_audiencia', '<=', now()->addDays(3))
            ->get();

        foreach ($audiencias as $audiencia) {
            Notification::send(
                $audiencia->abogado,
                new AudienciaRecordatorioNotification($audiencia)
            );
        }
    }

}
