<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <meta http-equiv="X-UA-Compatible" content="ie=edge">
  <title><?php echo e(config('app.name')); ?></title>
  <link rel="shortcut icon" href="<?php echo e(asset('favicon.ico')); ?>">

  <link href="https://fonts.googleapis.com/css?family=Karla:400,700&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="https://cdn.materialdesignicons.com/4.8.95/css/materialdesignicons.min.css">
  <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/css/bootstrap.min.css">
  <link rel="stylesheet" href="<?php echo e(asset('assets_login/css/login.css')); ?>">
  <!-- Sweet Alert --> 
  <script src="<?php echo e(asset('assets/js/plugin/sweetalert/sweetalert.min.js')); ?>"></script>
  <style>
    .captcha-container {
        max-width: 100%;
        display: flex;
        justify-content: center;
    }
    
    .captcha-img {
        width: 100%;
        max-width: 250px; /* ancho máximo en desktop */
        height: auto;
    }
  </style>
</head>
<body>
  <main class="d-flex align-items-center min-vh-100 py-3 py-md-0">
    <div class="container">
      <div class="card login-card">
        <div class="row no-gutters">
          <div class="col-md-5">
            <img src="<?php echo e(asset('assets_login/images/login1.png')); ?>" alt="login" class="login-card-img">
          </div>
          <div class="col-md-7">
            <div class="card-body">
              <div class="brand-wrapper text-center">
                <img src="<?php echo e(asset('assets_login/images/logo_intranet.png')); ?>" alt="logo" class="logo d-sm-none d-md-block d-lg-block" >
                <img src="<?php echo e(asset('assets_login/images/Logo_intranet_small.png')); ?>" alt="logo" class="logo d-md-none d-lg-none" >
              </div>
              <br>
              <?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            
              <p class="login-card-description">Bienvenid@ !!! <br>Ingrese sus datos para acceder, nombre de usario y contraseña</p>
              <p class="alert alert-warning">
                Por ejem. Si su correo es juan.perez@sedem.gob.bo solo considerar <strong>juan.perez </strong>, contraseña de su equipo o correo.
              </p>
              <form action="<?php echo e(route('login')); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php if($errors->any()): ?>
                    <ul style="list-style: none; " class="alert-danger">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="text-danger"><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                <?php endif; ?>
                  <div class="form-group mb-0 <?php echo e($errors->has('username') ? 'has-error' : ''); ?>">
                    <label for="username" class="sr-only">Nombre de Usuario</label>
                    <input type="text" class="form-control mb-3" placeholder="Nombre de usuario" name="username" value="<?php echo e(old('username')); ?>"  autocomplete="username" autofocus>
                    
                  </div>
                  <div class="form-group mb-0 <?php echo e($errors->has('password') ? 'has-error' : ''); ?>">
                    <label for="password" class="sr-only">Contraseña</label>
                    <input type="password" class="form-control mb-1" placeholder="Contraseña" name="password"  autocomplete="current-password">
                    
                  </div>
                  <div class="d-flex justify-content-center">
                      <div class="captcha-container mb-0">
                          <img src="<?php echo e(captcha_src('large')); ?>" alt="captcha" class="captcha-img" id="captcha-image">
                          <button type="button" class="btn btn-danger btn-refresh-captcha" id="refresh-captcha" title="">
                              ↻
                          </button>
                      </div>
                  </div>
                 <div class="input-group ">
                          <input id="captcha" type="text" class="form-control <?php $__errorArgs = ['captcha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"  placeholder="Ingrese el texto captcha"
                              name="captcha"  autocomplete="off">
                  </div>
                  <button type="submit" class="btn btn-block login-btn mb-4">Ingresar</button>
                </form>
                <!-- <div class="text-right"><a href="<?php echo e(route('redirect')); ?>" class="btn btn-seconday btn-icon" target="_blank"><i class="fas fa-edit"></i>X</a></div> -->
            </div>
          </div>
        </div>
      </div>

    </div>
  </main>
  <script src="https://code.jquery.com/jquery-3.4.1.min.js"></script>
  <script src="https://cdn.jsdelivr.net/npm/popper.js@1.16.0/dist/umd/popper.min.js"></script>
  <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.4.1/js/bootstrap.min.js"></script>
  <script>
    document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('refresh-captcha').addEventListener('click', function() {
        // Añadimos un parámetro aleatorio para evitar el caché
        document.getElementById('captcha-image').src = '<?php echo e(captcha_src('large')); ?>?' + Math.random();
    });
});
    </script>
</body>
</html>
<?php /**PATH /var/www/html/intranet/resources/views/intranet/auth/login.blade.php ENDPATH**/ ?>