
<?php $__env->startSection('titulo','Noticias'); ?>
<?php $__env->startSection('content'); ?>

<div class="panel-header img-fondo" style="background-image: url(<?php echo e(asset('assets/img/'.$pagina->banner_pagina)); ?>);">
    <div class="page-inner py-<?php echo e(session('unidad_id')==null ? '5' : '4'); ?>">
        <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row" style="z-index: 2;">
            <div>
                <?php if(session('unidad_id')!=null): ?> <h1 class="text-white mb-0 pb-0 fw-bold" style="position: relative; z-index: 3;"> <?php echo e(session('nombre_unidad')); ?> </h1><?php endif; ?>
                <h1 class="text-white pb-0 mb-0 fw-bold" style="position: relative; z-index: 3;"><?php echo e($pagina->titulo_pagina); ?></h1>
                <h3 class="text-white mb-5" style="position: relative; z-index: 3;"><?php echo e($pagina->descripcion_pagina); ?></h3>
            </div>
        </div>
    </div>
</div>
<div class="page-inner mt--5">
    <div class="row mt--2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <h4 class="card-title">Noticias y anuncios registrados hasta la fecha <strong><?php echo e($search != null ? 'buscando por "'.$search.'"' : ''); ?></strong></h4>
                        </div>
                        <div class="col-md-6 ">
                            <div class="d-flex justify-content-end">
                                <?php if($search!=null): ?>
                                    <a href="<?php echo e(route('noticias.publicadas')); ?>" class="btn btn-link">
                                        <span class="btn-label">
                                            <i class="fa fa-link"></i>
                                        </span>Ver Todas
                                    </a>
                                <?php endif; ?>
                                <div class="collapse" id="search-nav">
                                    <form class="navbar-left navbar-form nav-search" action="<?php echo e(route('noticias.publicadas')); ?>" method="get">
                                       <div class="input-group">
                                          <div class="input-group-prepend">
                                             <button type="submit" class="btn btn-search pr-1" data-toggle="tooltip" title="Presionar para realizar la búsqueda">
                                                <i class="fa fa-search search-icon"></i>
                                             </button>
                                          </div>
                                          <input type="text" placeholder="Ingrese una texto para la busqueda..." class="form-control " name="search" id="search">
                                       </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                   
                </div>
            </div>
        </div>
    </div>
</div>
<div class="page-inner mt--5">
    <div class="row mt--2">
        <?php $__empty_1 = true; $__currentLoopData = $noticias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $noticia): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="col-md-4 pb-3">
            <div class="card card-post card-round alto">
                <a href="<?php echo e(route('noticia.publicada', $noticia)); ?>" style="height: 300px; width: 100%; background-size: cover; background-position: center"><img class="card-img-top img-normalizada " src="<?php echo e(route('ver_adjuntos',$noticia->id)); ?>" alt="Noticia"></a>
                <div class="card-body pb-0 mb-0 pt-1">
                    <h4 class="text-primary mb-1 fw-bold"><?php echo e($noticia->tipo->nombre); ?></h4>
                    <span class="badge badge-gray text-left"><?php echo e($noticia->unidad != null ? $noticia->unidad->nombre : 'SEDEM'); ?></span><br>
                    <h6 class="text-dark fw-bold">Publicado por: <?php echo e($noticia->creador->name); ?></h6>
                    <h3 class="mt-1"><?php echo e($noticia->titulo); ?> </h3>
                    <h5 class="card-text mb-0 pb-0"><?php echo e(date('d/m/Y',strtotime($noticia->fecha))); ?></h5>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="col-md-12  bg-warning-light text-center">
            <h3 class="pt-2 pb-2 ">No se encontraron noticias...</h3>
        </div>          
        <?php endif; ?>
        <?php echo e($noticias->links()); ?>

    </div>
</div>
 <?php $__env->stopSection(); ?>

<?php echo $__env->make('intranet.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/intranet/resources/views/intranet/noticias.blade.php ENDPATH**/ ?>