

<?php $__env->startSection('titulo','Capacitación'); ?>
<?php $__env->startSection('content'); ?>

<div class="panel-header img-fondo" style="background-image: url(<?php echo e(asset('assets/img/'.$pagina->banner_pagina)); ?>);">
    <div class="page-inner py-<?php echo e(session('unidad_id')==null ? '5' : '4'); ?>">
        <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row" style="z-index: 2;">
            <div>
                <?php if(session('unidad_id')!=null): ?> <h1 class="text-white mb-0 pb-0 fw-bold" style="position: relative; z-index: 3;"> <?php echo e(session('nombre_unidad')); ?> </h1><?php endif; ?>
                <h1 class="text-white pb-0 mb-0 fw-bold" style="position: relative; z-index: 3;"><?php echo e($pagina->titulo_pagina); ?></h1>
                <h3 class="text-white mb-2" style="position: relative; z-index: 3;"><?php echo e($pagina->descripcion_pagina); ?></h3>
            </div>
        </div>
    </div>
</div>

                                        
<div class="page-inner mt--5">
    <div class="row mt--2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col-md-6">
                            <h4 class="card-title">Videos de capacitación para el personal <strong><?php echo e($search != null ? 'buscando por "'.$search.'"' : ''); ?></strong></h4>
                        </div>
                        <div class="col-md-6 ">
                            <div class="d-flex justify-content-end">
                                <?php if($search!=null): ?>
                                    <a href="<?php echo e(route('capacitacion.show')); ?>" class="btn btn-link">
                                        <span class="btn-label">
                                            <i class="fa fa-link"></i>
                                        </span>Ver Todas
                                    </a>
                                <?php endif; ?>
                                <div class="collapse" id="search-nav">
                                    <form class="navbar-left navbar-form nav-search" action="<?php echo e(route('capacitacion.show')); ?>" method="get">
                                       <div class="input-group">
                                          <div class="input-group-prepend">
                                             <button type="submit" class="btn btn-search pr-1" data-toggle="tooltip" title="Presionar para realizar la búsqueda">
                                                <i class="fa fa-search search-icon"></i>
                                             </button>
                                          </div>
                                          <input type="text" placeholder="Ingrese una texto para la busqueda..." class="form-control " name="search" id="search">
                                       </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                   
                </div>
            </div>
        </div>
    </div>
</div> 
<div class="page-inner mt--5">
    <div class="row mt--2">
        <?php $__empty_1 = true; $__currentLoopData = $archivos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $video): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <div class="col-md-4 pb-3">
            <div class="card video-container card-round alto">
                <a href="javascript:void(0)"  style="height: 300px; width: 100%; background-size: cover; background-position: center">
                    <video  preload="metadata" controls >
                        <source src="<?php echo e(route('ver_adjuntos',$video->id)); ?>" type="video/mp4" >
                    </video>
                </a>
                <div class="card-body pb-0 mb-0 pt-2">       
                    <h3 class="mt-1"><?php echo e(date('d/m/Y',strtotime($video->fecha))); ?> - <?php echo e($video->titulo); ?> </h3>
                    <h3><?php echo nl2br(preg_replace(
                        '/(https?:\/\/[^\s]+)/',
                        '<a href="$1" target="_blank" rel="noopener noreferrer">$1</a>',
                        e($video->descripcion)
                    )); ?></h3>
                </div>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div class="col-md-12  bg-warning-light text-center">
            <h3 class="pt-2 pb-2 ">No se encontraron archivos...</h3>
        </div>          
        <?php endif; ?>
    </div>
</div>
        <!-- Modal -->
<div class="modal fade" id="videoModal" tabindex="-1" aria-labelledby="videoModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="videoModalLabel">Reproduciendo Video</h5>
                <button type="button" class="btn-close" data-dismiss="modal" aria-label="Close">X</button>
            </div>
            <div class="modal-body">
                <video id="videoPlayer" controls style="width: 100%;">
                    <source src="" type="video/mp4">
                    Tu navegador no soporta el elemento de video.
                </video>
            </div>
        </div>
    </div>
</div>
 <?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const playButtons = document.querySelectorAll('.play-video');
        const videoModal = new bootstrap.Modal(document.getElementById('videoModal'));
        const videoPlayer = document.getElementById('videoPlayer');

        playButtons.forEach(button => {
            button.addEventListener('click', function() {
                const videoUrl = this.getAttribute('data-video-url');
                videoPlayer.src = videoUrl;
                videoModal.show();
            });
        });

        videoModal._element.addEventListener('hidden.bs.modal', function () {
            videoPlayer.pause();
            videoPlayer.currentTime = 0;
        });
    });
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('intranet.layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/intranet/resources/views/intranet/capacitacion.blade.php ENDPATH**/ ?>