<!DOCTYPE html>
<html>
<head>
    <style>
        @page {
            margin: 0;
        }

        body {
            font-family: sans-serif;
            margin: 0;
            padding-top: 150px;
            padding-left: 20px;
            padding-right: 20px;
            font-size: 8pt;
            background-image: url('<?php echo e(public_path().'/assets/img/fondo_cumple_mes.png'); ?>');
            background-size: cover;
            background-repeat: no-repeat;
            background-position: center;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            table-layout: fixed;
        }

        td {
            vertical-align: top;
            width: 25%;
            padding: 5px;
        }

        .registro {
            margin-bottom: 8px;
            page-break-inside: avoid;
            border-radius: 10px;
            padding: 5px;
            /* background-color: rgba(255, 255, 255, 0.8); */
            background-color: #FEF9E1;
        }

        .circle {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background-color: #045a72;
            color: white;
            text-align: center;
            line-height: 40px;
            font-size: 14pt;
            margin-bottom: 5px;
        }

        .content {
            padding-top: 0;
            page-break-inside: auto;
        }

        h2 {
            font-size: 12pt;
            margin: 0;
            color: #4A4A4A;
        }

        strong {
            color: #333;
        }
    </style>
</head>
<body>
    <div class="content">
        <table>
            <?php
                $columnCount = 4;
                $dias = collect($cumpleaños)->groupBy('fecha');
            ?>

            <?php $__currentLoopData = $dias->chunk($columnCount); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $diaChunk): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <?php $__currentLoopData = $diaChunk; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $fecha => $personas): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <td>
                            <div class="registro">
                                <div class="circle"><?php echo e($fecha); ?></div>
                                <?php $__currentLoopData = $personas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $persona): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div>
                                        <strong style="font-size: 10pt; <?php echo e($persona->genero=='MASCULINO' ? 'color:#143D60;' : 'color:#B03052;'); ?>"><?php echo e($persona->nombre); ?></strong><br>
                                        <?php echo e($persona->unidad); ?><br>
                                    </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </td>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </table>
    </div>
</body>
</html>
<?php /**PATH /var/www/html/intranet/resources/views/intranet/pdf/cumpleaños_mes.blade.php ENDPATH**/ ?>