<div>
    <div class="row mb-3">
        <div class="col-lg-2 col-md-4 col-sm-12 ">
            <div class="form-group">
                <i class="fas fa-filter mr-2"></i><label for="">Tipo Contenido</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="tipoFiltro" class="form-control">
                        <option value="">-- VER TODOS --</option>
                        <?php $__currentLoopData = $tipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($t->id); ?>"><?php echo e($t->nombre); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </div>
        <div class="col-lg-2 col-md-4 col-sm-12">
            <div class="form-group">
                <i class="fas fa-filter mr-2"></i><label for="">Estado</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="estadoFiltro" class="form-control ">
                        <option value="">-- VER TODOS --</option>
                        <option value="true">Publicado</option>
                        <option value="false">No Publicado</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="col-lg-2 col-md-4 col-sm-12">
            <div class="form-group  ">
                <i class="fas fa-filter mr-2"></i><label for="">Visible</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="visibleFiltro" class="form-control ">
                        <option value="">-- VER TODOS --</option>
                        <option value="1">Para Todos</option>
                        <option value="false">Solo Para la Unidad</option>
                    </select>
                </div>
            </div>
        </div>
        <?php if(auth()->user()->unidad_id == null || auth()->user()->rol[0]->id==3): ?>
        <div class="col-lg-3 col-md-6 col-sm-12">
            <div class="form-group">
                <i class="fas fa-filter mr-2"></i><label for="">Unidad Institucional</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="unidadFiltro" class="form-control unidad_id">
                        <option value="">-- VER TODOS --</option>
                        <?php $__currentLoopData = $unidades; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $unidad): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($unidad->id); ?>"><?php echo e($unidad->nombre); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <button class="btn btn-info btn-icon btn-sm" wire:click="borrar_unidad" title="Borrar Selección"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
        <?php endif; ?>
        <div class="col-lg-3 col-md-6 col-sm-12">
            <div class="form-group  ">
                <i class="fas fa-search mr-2"></i><label for="">Buscar</label>
                <div class="d-flex align-items-center justify-content-center">
                    <input type="text" wire:model="search" id="searchFilter" class="form-control" placeholder="Ingrese una palabra....">
                    <button class="btn btn-info btn-icon btn-sm" wire:click="borrar_search" title="Borrar Contenido"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table table-hover table-sm datatable">
            <thead>
              <th class="text-center">Fecha</th>
              <th class="text-center">Título</th>
              <th class="text-center">Visible</th>
              <th class="text-center">Estado</th>
              <th class="text-center"></th>
            </thead>
            <tbody>
              <?php $__empty_1 = true; $__currentLoopData = $noticias; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <tr>
                  <td class="text-center"><?php echo e(date('d/m/Y',strtotime( $c->fecha))); ?></td>
                  <td class="text-left"><?php echo e($c->titulo); ?> <br>
                    <span class="badge badge-gray"><?php echo e($c->unidad != null ? $c->unidad->nombre : 'SEDEM'); ?></span><br>
                    <span class="badge badge-warning"><?php echo e($c->tipo); ?></span> <br>
                  </td>
                  <td class="text-center"><?php if($c->visible == 1): ?> <span class="badge badge-success">PARA TODOS</span> <?php else: ?> <span class="badge badge-danger">SOLO UNIDAD</span> <?php endif; ?></td>
                  <td class="text-center"><?php if($c->estado==0): ?> <span class="badge badge-danger">NO PUBLICADO</span> <?php else: ?> <span class="badge badge-success">PUBLICADO</span> <?php endif; ?></td>
                  <td class="text-center">
                    <button class="btn btn-default btn-round dropdown-toggle" type="button" data-toggle="dropdown">
                        OPCIONES
                    </button>
                    <ul class="dropdown-menu" role="menu">
                        <li>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('noticias.edit')): ?>
                                <a class="dropdown-item" href="<?php echo e(route('noticias.edit', $c)); ?>" data-toggle="tooltip" data-placement="bottom"  title="Editar datos del registro" href="#">Modificar Datos</a>
                                <?php if($c->estado==0): ?>
                                    <a class="dropdown-item" href="<?php echo e(route('noticias.publicar', $c)); ?>"  data-toggle="tooltip" data-placement="bottom" title="Publicar contenido" onclick="return confirm('¿Está seguro que desea PUBLICAR la NOTICIA/ANUNCIO?');">Publicar</a>
                                <?php else: ?>
                                    <a class="dropdown-item" href="<?php echo e(route('noticias.no_publicar', $c)); ?>" data-toggle="tooltip" data-placement="bottom" title="Dar de baja su publicación" onclick="return confirm('¿Está seguro que desea DAR DE BAJA la publicación de la NOTICIA/ANUNCIO?');">Dar de Baja</a>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if($c->adjunto != null): ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('noticias.show')): ?>
                                    <a class="dropdown-item" href="<?php echo e(route('noticias.show',$c->id)); ?>" data-toggle="tooltip" data-placement="bottom" title="Ver adjunto" target="_blank">Ver Detalle</a>
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('noticias.destroy')): ?>
                                <form action="<?php echo e(route('noticias.destroy', $c)); ?>" method="POST" style="display: inline-block;">
                                    <?php echo csrf_field(); ?>
                                    <?php echo method_field('DELETE'); ?>
                                    <button type="submit" class="dropdown-item text-danger" data-toggle="tooltip" data-placement="bottom" title="Eliminar Registro" onclick="return confirm('¿Está seguro que desea eliminar la NOTICIA/ANUNCIO?');">Eliminar</button>
                                </form>
                            <?php endif; ?>
                        </li>
                    </ul>
                  </td>
                </tr>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
              <div class="bg-warning text-center">
                  <h3 class="pt-2 pb-2">No se encontraron noticias registradas...</h3>
              </div>
              <?php endif; ?>
            </tbody>
          </table>
        <div class="d-flex justify-content-end"><?php echo e($noticias->links('pagination::bootstrap-4')); ?></div>
    </div>
</div>
<?php $__env->startSection('scripts'); ?>
<script>
    $(document).ready(function () {
        window.initSelectFiltros=()=>{
            $('.unidad_id').select2();

            $('.tipo_contenido').select2({
                width: 'resolve'
            });

        }
        initSelectFiltros();
        $('.tipo_contenido').on('change', function () {
            window.livewire.find('<?php echo e($_instance->id); ?>').set('tipoFiltro', $(this).val());
        });
        $('.unidad_id').on('change', function () {
            window.livewire.find('<?php echo e($_instance->id); ?>').set('unidadFiltro', $(this).val());
        });
        
        window.livewire.on('select2',()=>{
            initSelectFiltros();
        });
    });
</script>
<?php $__env->stopSection(); ?><?php /**PATH /var/www/html/intranet/resources/views/livewire/admin/noticia-component.blade.php ENDPATH**/ ?>