<?php $__env->startSection('titulo','Usuarios'); ?>
<?php $__env->startSection('content'); ?>

<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Usuarios</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="<?php echo e(route('home')); ?>"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Configuración Accesso</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Usuarios</a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex align-items-center justify-content-between">
                        <h4 class="card-title">Usuarios registrados hasta la fecha</h4>
                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.create')): ?><a href="<?php echo e(route('users.create')); ?>" class="btn btn-primary btn-round mr-2">Agregar Nuevo</a><?php endif; ?>
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="table-responsive">
                                <table width="100%" id="datos" class="table table-hover table-sm">
                                    <thead>
                                        <tr>
                                            <th class="text-center">Nombre Completo</th>
                                            <th class="text-center">CI</th>
                                            <th class="text-center">Nombre de Usuario</th>
                                            <th class="text-center">Correo Institucional</th>
                                            <th class="text-center">Rol Asignado</th>
                                            <th class="text-center">Unidad SEDEM</th>
                                            <th class="text-center">Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php $__currentLoopData = $users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($user->id != 1 && $user->id != auth()->user()->id): ?>
                                            <tr>
                                                <td><?php echo e($user->name); ?></td>
                                                <td class="text-center"><?php echo e($user->empleado_ci); ?></td>
                                                <td class="text-center"><?php echo e($user->username); ?></td>
                                                <td class="text-center"><?php echo e($user->email); ?></td>
                                                <td class="text-center">
                                                    <?php $__currentLoopData = $user->roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rol): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <strong><?php echo e($rol->name); ?></strong>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </td>
                                                <td class="text-center"><?php echo e($user->unidad ? $user->unidad->nombre : '--UNIDAD ELIMINADA--'); ?></td>
                                                <td>
                                                    <div class="d-flex align-items-center justify-content-center">
                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.edit')): ?>
                                                            <a href="<?php echo e(route('users.edit',$user->id)); ?>" class="btn btn-warning btn-round btn-icon " title="Modificar datos"><button class="btn btn-warning btn-round btn-icon "><i class="fas fa-edit"></i></button></a>
                                                        <?php endif; ?>
                                                        <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('users.destroy')): ?>
                                                            <a href="<?php echo e(route('users.destroy',$user->id)); ?>"  title="Eliminar Registro" onclick="return confirm('¿Está seguro que desea eliminar al USUARIO?');"><button class="btn btn-danger btn-round btn-icon "><i class="fas fa-trash-alt"></i></button></a>
                                                        <?php endif; ?>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
 <script src="<?php echo e(asset('assets/js/tablas/basica.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app_admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/intranet/resources/views/admin/users/index.blade.php ENDPATH**/ ?>