
<?php $__env->startSection('titulo','Directorio Empleados'); ?>
<?php $__env->startSection('content'); ?>


<div class="page-inner">
  <div class="page-header">
      <h4 class="page-title">Ver Directorio</h4>
      <ul class="breadcrumbs">
          <li class="nav-home"><a href="<?php echo e(route('home')); ?>"><i class="flaticon-home"></i></a></li>
          <li class="separator"><i class="flaticon-right-arrow"></i></li>
          <li class="nav-item"><a href="javascript:void(0)">Directorio</a></li>
          <li class="separator"><i class="flaticon-right-arrow"></i></li>
          <li class="nav-item"><a href="#">Ver Directorio</a></li>
      </ul>
  </div>
  <div class="row">
      <div class="col-md-12">
          <div class="card">
              <div class="card-header">
                  <div class="d-flex align-items-center justify-content-between">
                    <div>
                      <div class="card-title">Directorio de empleados </div>
                      <div class="card-category">Listado de empleados registrados para cada unidad.</div>
                    </div>
                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('directorio_empleados.create')): ?>
                      <div>
                          <a href="<?php echo e(route('directorio_empleados.create')); ?>" class="btn btn-primary btn-rounded">Agregar Nuevo</a>
                          
                      </div>
                    <?php endif; ?>
                  </div>
              </div>
              <div class="card-body">
                <div class="table-responsive">
                  <table class="table table-hover table-sm" id="datos">
                    <thead>
                      <th class="text-center">Interno</th>
                      <th class="text-center">Nombre Completo</th>
                      <th class="text-center">Cargo</th>
                      <th class="text-center">Unidad</th>
                      <th class="text-center">Area</th>
                      <th class="text-center"></th>
                    </thead>
                    <tbody>
                      <?php $__currentLoopData = $directorio_empleados; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $directorio): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <tr>
                          <td class="text-center"><?php echo e($directorio->interno); ?></td>
                          <td class="text-left"><?php echo e($directorio->nombre); ?></td>
                          <td class="text-left"><?php echo e($directorio->cargo); ?></td>
                          <td class="text-center"><?php echo e($directorio->unidad ? $directorio->unidad->nombre : ''); ?></td>
                          <td class="text-center"><?php echo e($directorio->unidad ? $directorio->unidad->area->nombre : ''); ?></td>
                          <td class="text-center">
                            <button class="btn btn-default btn-round dropdown-toggle" type="button" data-toggle="dropdown"> 
                              OPCIONES
                              </button>
                              <ul class="dropdown-menu" role="menu">
                                  <li>
                                      <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('directorio_empleados.edit')): ?>
                                          <a class="dropdown-item" href="<?php echo e(route('directorio_empleados.edit', $directorio)); ?>">Modificar Datos</a>
                                      <?php endif; ?>
                                      <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('directorio_empleados.destroy')): ?>
                                          <form action="<?php echo e(route('directorio_empleados.destroy', $directorio)); ?>" method="POST" style="display: inline-block;">
                                              <?php echo csrf_field(); ?>
                                              <?php echo method_field('DELETE'); ?>
                                              <button type="submit" class="dropdown-item text-danger" onclick="return confirm('¿Está seguro que desea ELIMINAR el registro del DIRECTORIO?');">Eliminar</button>
                                          </form>
                                      <?php endif; ?>
                                  </li>
                              </ul>
                          </td>
                        </tr>
                      <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                  </table>
                </div>
              </div>
          </div>
      </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script src="<?php echo e(asset('assets/js/tablas/basica.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.app_admin', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/intranet/resources/views/admin/directorio/index.blade.php ENDPATH**/ ?>