<div>
    <div class="row mb-3">
        <div class="col-lg-2 col-md-4 col-sm-12 ">
            <div class="form-group">
                <i class="fas fa-filter mr-2"></i><label for="">Tipo Contenido</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="tipoFiltro" class="form-control">
                        <option value="">-- VER TODOS --</option>
                        @foreach ($tipos as $t)
                            <option value="{{ $t->id }}">{{ $t->nombre }}</option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>
        <div class="col-lg-2 col-md-4 col-sm-12">
            <div class="form-group">
                <i class="fas fa-filter mr-2"></i><label for="">Estado</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="estadoFiltro" class="form-control ">
                        <option value="">-- VER TODOS --</option>
                        <option value="true">Publicado</option>
                        <option value="false">No Publicado</option>
                    </select>
                </div>
            </div>
        </div>
        <div class="col-lg-2 col-md-4 col-sm-12">
            <div class="form-group  ">
                <i class="fas fa-filter mr-2"></i><label for="">Visible</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="visibleFiltro" class="form-control ">
                        <option value="">-- VER TODOS --</option>
                        <option value="1">Para Todos</option>
                        <option value="false">Solo Para la Unidad</option>
                    </select>
                </div>
            </div>
        </div>
        @if(auth()->user()->unidad_id == null || auth()->user()->rol[0]->id==3)
        <div class="col-lg-3 col-md-6 col-sm-12">
            <div class="form-group">
                <i class="fas fa-filter mr-2"></i><label for="">Unidad Institucional</label>
                <div  wire:ignore class="d-flex align-items-center justify-content-center">
                    <select wire:model="unidadFiltro" class="form-control unidad_id">
                        <option value="">-- VER TODOS --</option>
                        @foreach ($unidades as $unidad)
                            <option value="{{ $unidad->id }}">{{ $unidad->nombre }}</option>
                        @endforeach
                    </select>
                    <button class="btn btn-info btn-icon btn-sm" wire:click="borrar_unidad" title="Borrar Selección"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
        @endif
        <div class="col-lg-3 col-md-6 col-sm-12">
            <div class="form-group  ">
                <i class="fas fa-search mr-2"></i><label for="">Buscar</label>
                <div class="d-flex align-items-center justify-content-center">
                    <input type="text" wire:model="search" id="searchFilter" class="form-control" placeholder="Ingrese una palabra....">
                    <button class="btn btn-info btn-icon btn-sm" wire:click="borrar_search" title="Borrar Contenido"><i class="fas fa-times"></i></button>
                </div>
            </div>
        </div>
    </div>
    <div class="table-responsive">
        <table class="table table-hover table-sm datatable">
            <thead>
              <th class="text-center">Fecha</th>
              <th class="text-center">Título</th>
              <th class="text-center">Visible</th>
              <th class="text-center">Estado</th>
              <th class="text-center"></th>
            </thead>
            <tbody>
              @forelse($noticias as $c)
                <tr>
                  <td class="text-center">{{date('d/m/Y',strtotime( $c->fecha)) }}</td>
                  <td class="text-left">{{ $c->titulo }} <br>
                    <span class="badge badge-gray">{{ $c->unidad != null ? $c->unidad->nombre : 'SEDEM' }}</span><br>
                    <span class="badge badge-warning">{{ $c->tipo }}</span> <br>
                  </td>
                  <td class="text-center">@if($c->visible == 1) <span class="badge badge-success">PARA TODOS</span> @else <span class="badge badge-danger">SOLO UNIDAD</span> @endif</td>
                  <td class="text-center">@if($c->estado==0) <span class="badge badge-danger">NO PUBLICADO</span> @else <span class="badge badge-success">PUBLICADO</span> @endif</td>
                  <td class="text-center">
                    <button class="btn btn-default btn-round dropdown-toggle" type="button" data-toggle="dropdown">
                        OPCIONES
                    </button>
                    <ul class="dropdown-menu" role="menu">
                        <li>
                            @can('noticias.edit')
                                <a class="dropdown-item" href="{{ route('noticias.edit', $c) }}" data-toggle="tooltip" data-placement="bottom"  title="Editar datos del registro" href="#">Modificar Datos</a>
                                @if($c->estado==0)
                                    <a class="dropdown-item" href="{{ route('noticias.publicar', $c) }}"  data-toggle="tooltip" data-placement="bottom" title="Publicar contenido" onclick="return confirm('¿Está seguro que desea PUBLICAR la NOTICIA/ANUNCIO?');">Publicar</a>
                                @else
                                    <a class="dropdown-item" href="{{ route('noticias.no_publicar', $c) }}" data-toggle="tooltip" data-placement="bottom" title="Dar de baja su publicación" onclick="return confirm('¿Está seguro que desea DAR DE BAJA la publicación de la NOTICIA/ANUNCIO?');">Dar de Baja</a>
                                @endif
                            @endcan
                            @if($c->adjunto != null)
                                @can('noticias.show')
                                    <a class="dropdown-item" href="{{ route('noticias.show',$c->id) }}" data-toggle="tooltip" data-placement="bottom" title="Ver adjunto" target="_blank">Ver Detalle</a>
                                @endcan
                            @endif
                            @can('noticias.destroy')
                                <form action="{{ route('noticias.destroy', $c) }}" method="POST" style="display: inline-block;">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="dropdown-item text-danger" data-toggle="tooltip" data-placement="bottom" title="Eliminar Registro" onclick="return confirm('¿Está seguro que desea eliminar la NOTICIA/ANUNCIO?');">Eliminar</button>
                                </form>
                            @endcan
                        </li>
                    </ul>
                  </td>
                </tr>
              @empty
              <div class="bg-warning text-center">
                  <h3 class="pt-2 pb-2">No se encontraron noticias registradas...</h3>
              </div>
              @endforelse
            </tbody>
          </table>
        <div class="d-flex justify-content-end">{{ $noticias->links('pagination::bootstrap-4') }}</div>
    </div>
</div>
@section('scripts')
<script>
    $(document).ready(function () {
        window.initSelectFiltros=()=>{
            $('.unidad_id').select2();

            $('.tipo_contenido').select2({
                width: 'resolve'
            });

        }
        initSelectFiltros();
        $('.tipo_contenido').on('change', function () {
            @this.set('tipoFiltro', $(this).val());
        });
        $('.unidad_id').on('change', function () {
            @this.set('unidadFiltro', $(this).val());
        });
        
        window.livewire.on('select2',()=>{
            initSelectFiltros();
        });
    });
</script>
@endsection