
@extends('intranet.layouts.app')
@section('titulo','Social y Comunidad')
@section('content')

<div class="panel-header img-fondo" style="background-image: url({{ asset('assets/img/'.$pagina->banner_pagina) }});">
    <div class="page-inner py-{{ session('unidad_id')==null ? '5' : '4' }}">
        <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row" style="z-index: 2;">
            <div>
                @if(session('unidad_id')!=null) <h1 class="text-white mb-0 pb-0 fw-bold" style="position: relative; z-index: 3;"> {{ session('nombre_unidad') }} </h1>@endif
                <h1 class="text-white pb-0 mb-0 fw-bold" style="position: relative; z-index: 3;">{{ $pagina->titulo_pagina }}</h1>
                <h3 class="text-white mb-2" style="position: relative; z-index: 3;">{{ $pagina->descripcion_pagina }}</h3>
            </div>
        </div>
    </div>
</div>

<div class="page-inner mt--5">
    <div class="row mt--2">
        <div class="col-md-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Galeria de Fotos</h4>
                    <p class="card-category">Presione sobre cada foto para tener mejor visibilidad o ver toda la galeria</p>
                </div>
                <div class="card-body">
                    
                    <div class="row image-gallery">
                        @forelse ($sociales as $social)
                        <a href="{{ route('ver_adjuntos',$social->id) }}" class="col-6 col-md-3 mb-4" style="width: 300px; height: 300px;">
                            <img src="{{ route('ver_adjuntos',$social->id) }}" class="img-fluid" style="width: 300px; height: 300px;">
                            <div class="photo-text" style="display: -webkit-box; -webkit-line-clamp: 4; -webkit-box-orient: vertical; overflow: hidden;">{{ date('d/m/Y', strtotime($social->fecha)) }} - {{ $social->titulo }}</div>
                        </a>
                        @empty
                        <div class="col-md-12  bg-warning-light text-center">
                            <h3 class="pt-2 pb-2 ">No se publicaron fotos de convivencia...</h3>
                        </div>
                        @endforelse
                        
                    </div>
                </div>
            </div>
        </div>
        
       
    </div>
</div>

 @endsection
 @section('scripts')
 <script>
   
    // This will create a single gallery from all elements that have class "gallery-item"
    $('.image-gallery').magnificPopup({
        delegate: 'a', 
        type: 'image',
        removalDelay: 300,
        gallery:{
            enabled:true,
        },
        mainClass: 'mfp-with-zoom', 
        zoom: {
            enabled: true, 
            duration: 300,
            easing: 'ease-in-out',
            opener: function(openerElement) {
                return openerElement.is('img') ? openerElement : openerElement.find('img');
            }
        }
    });
</script>
 @endsection
