@extends('intranet.layouts.app')
@section('titulo','Resultado busqueda')
@section('content')


<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Resultado de Búsqueda</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="{{ route('welcome') }}"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Resultado de Búsqueda</a></li>
        </ul>
      </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Resultados encontrados según el criterio de búsqueda palabra <strong>"{{ $query }}"</strong></h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-sm" id="datos">
                                    <thead>
                                        <tr>
                                            <th class="text-center">Sección</th>
                                            <th class="text-center">Fecha Publicación</th>
                                            <th class="text-center">Resolución</th>
                                            <th class="text-center">Titulo</th>
                                            <th class="text-center">Contenido</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @forelse($groupedResults as $section => $results)
                                        @foreach ($results as $result)
                                        <tr>
                                            <th>
                                                {{ $result['section'] }}
                                            </th>
                                            <td class="text-center">{{ date('d/m/Y',strtotime($result['fecha'])) }}</td>
                                            <td>{{ $result['nro_resolucion'] }}</td>
                                            <td>
                                                @if($result['section']=='Capacitación')
                                                <a href="{{ route('ver_adjuntos', $result['id']) }}" target="_blank" class="btn btn-link btn-danger pb-0 pt-0"><i class="fas fa-video"></i> Ver</a>
                                                @else
                                                <a class="btn btn-link btn-danger pb-0 pt-0" href="{{ $result['section']=='Noticias y Anuncios' ? route('noticia.publicada', $result['id']) : route('ver_adjuntos', $result['id']) }}" target="_blank"><i class="fas fa-file-pdf"></i> Ver</a>
                                                @endif
                                                {{ $result['title'] }}
                                            </td>
                                            <td>{{ $result['content'] }}</td>
                                        </tr>
                                        @endforeach
                                        @empty
                                            <h4>No existen registros que coincidan con la palabras ingresada...</h4>
                                        @endforelse
                                    </tbody>
                                </table>
                            </div>
                            {{-- <ol class="activity-feed"> --}}
                                
                            {{-- @forelse($groupedResults as $section => $results)
                                @foreach ($results as $result)
                                <li class="feed-item pb-1 feed-item-success">
                                    <div class="d-flex">
                                        <time class="date mr-3 text-danger" datetime="9-24">{{ $result['section'] }}</time>
                                        <span class="text" style="display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden;">
                                            {{ $result['title'] }} - {{ $result['content'] }}
                                            @if($result['section']=='Capacitación')
                                            <a href="{{ route('ver_adjuntos/', $result['id']) }}" target="_blank"><span class="badge badge-default">VER</span></a>
                                            @else
                                            <a href="{{ $result['section']=='Noticias y Anuncios' ? route('noticia.publicada', $result['id']) : route('ver_adjuntos', $result['id']) }}" target="_blank"><span class="badge badge-default">VER</span></a>
                                            @endif
                                        </span>
                                    </div>
                                </li>
                                @endforeach
                                @empty
                                <h4>No existen registros que coincidan con la palabras ingresada...</h4>
                            @endforelse
                            </ol> --}}
                        </div>
                    </div>                            
                </div>
            </div>
        </div>
    </div>
</div>
 @endsection
 @section('scripts')
 <script src="{{asset('assets/js/tablas/basica.js')}}"></script>
 @endsection
