@extends('intranet.layouts.app')
@section('titulo','Mis Datos')
@section('content')
<div class="panel-header bg-primary-gradient ">
    <div class="page-inner py-5">
        <div class="d-flex align-items-left align-items-md-center flex-column flex-md-row">
            <div>
                <h2 class="text-white pb-2 fw-bold" style="position: relative; z-index: 3;">MIS DATOS</h2>
            </div>
        </div>
    </div>
</div>
<div class="page-inner mt--5">
    <div class="row mt--2">
        <div class="col-xl-4">
          <div class="card">
            <div class="card-body profile-card pt-4 d-flex flex-column align-items-center">
              <div class="avatar avatar-xxl"><img src="{{ asset('assets/img/avatars/'.auth()->user()->avatar) }}" alt="Profile" class="avatar-img rounded-circle"></div><br>
              <h2 class="text-center">{{ $user->name }}</h2>
            </div>
          </div>
        </div>
        <div class="col-xl-8">
          <div class="card card-with-nav">
            <div class="card-body pt-3">
              <!-- Bordered Tabs -->
              <ul class="nav nav-tabs nav-line nav-color-primary">
                <li class="nav-item">
                  <button class="nav-link @if (count($errors)==0)active @endif" data-bs-toggle="tab" data-bs-target="#profile-overview">Mis Datos</button>
                </li>
                <li class="nav-item">
                  <button class="nav-link @if($errors->hasAny(['name', 'username','avatar'])) active @endif" data-bs-toggle="tab" data-bs-target="#profile-edit">Modificar Mis Datos</button>
                </li>
                <li class="nav-item">
                  <button class="nav-link @if($errors->hasAny(['current_password','password', 'password_confirmation','validation.password','new_password'])) active @endif" data-bs-toggle="tab" data-bs-target="#profile-change-password">Cambiar Contraseña</button>
                </li>
              </ul>
              <div class="tab-content pt-2">
                <div class="tab-pane fade @if( count($errors)==0 ) show active @endif profile-overview" id="profile-overview">
                    <div class="row mt-3">
                        <div class="col-md-6">
                            <div class="form-group form-group-default">
                                <label>Nombre</label>
                                <div class="">{{ $user->name }} </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group form-group-default">
                                <label>Nombre de Usuario</label>
                                <div>{{ $user->username }}</div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="form-group form-group-default">
                                <label>Cargo</label>
                                <div>{{ $user->cargo }} <br> {{ $user->unidad_rrhh }} <br> {{ $user->area_rrhh }} </div>
                            </div>
                        </div>
                    </div>
                    <div class="row mt-3">
                        <div class="col-md-12">
                            <div class="form-group form-group-default">
                                <label>Rod asignado</label>
                                <div>{{ $user->rol[0]->name }}</div>
                            </div>
                        </div>
                    </div>
                </div>
  
                <div class="tab-pane fade profile-edit pt-3 @if($errors->hasAny(['name', 'username','avatar'])) show active @endif" id="profile-edit">
                  <!-- Cambiar datos personales -->
                    {!! Form::model($user,['route'=>['users.update_profile',$user->id],'method'=>'PUT','enctype'=>"multipart/form-data"]) !!}
                        <p>Puede ingresar los nuevos valores para el nombre completo o email y presionar el botón <strong>GUARDAR</strong> para que se guarde en el sistema. El correo electronico permite acceder al sistema.</p>
                        @if ($errors->hasAny(['name', 'username','avatar']))
                            <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
                            <ul class="list-ticked">
                                @foreach ($errors->all() as $error)
                                    <li class="text-danger">{{ $error }}</li>
                                @endforeach
                            </ul>
                        @endif
                        <div class="row mb-3">
                            <label for="profileImage" class="col-md-4 col-form-label text-right">Foto de Perfil</label>
                            <div class="d-flex align-items-center justify-content-center">
                                <div class="avatar avatar-xl">
                                    <img src="{{ asset('assets/img/avatars/'.auth()->user()->avatar) }}" alt="Profile" id="imagen" class="avatar-img rounded-circle">
                                </div>
                                <div class="pt-2">
                                    <label for="fileInput" class="btn btn-warning btn-round btn-icon" title="Cambiar Foto">
                                        <i class="fas fa-upload pt-2"></i>
                                    </label>
                                    <input type="file" id="fileInput" name="avatar" style="display: none;" accept="image/*">
                                </div>
                            </div>
                        </div>
                        <div class="row mb-1 {{ $errors->has('name') ? 'has-error' : '' }}">
                            <label for="name" class="col-md-4  col-form-label text-right">Nombre Completo: <span class="text-danger">(*)</span></label>
                            <div class="col-md-6">
                                <input id="name" type="text" class="form-control" name="name" value="{{ old('name',$user->name) }}"  autofocus onkeyup="javascript:this.value=this.value.toUpperCase();" >
                            </div>
                        </div>
                        <div class="row mb-1 {{ $errors->has('name') ? 'has-error' : '' }}">
                            <label for="username" class="col-md-4 col-form-label text-right ">Nombre de usuario <span class="text-danger">(*)</span></label>
                            <div class="col-md-6">
                                <input id="username" type="username" class="form-control" name="username" value="{{ old('username',$user->username) }}" >
                            </div>
                        </div>
                        <div class="text-center mt-2">
                            <button type="submit" class="btn btn-primary btn-round">Guardar Cambios</button>
                        </div>
                    {!! Form::close() !!}
                </div>
  
                <div class="tab-pane fade pt-3 @if($errors->hasAny(['current_password','password', 'password_confirmation','validation.password','new_password'])) show active @endif" id="profile-change-password">
                  <!-- Change Password Form -->
                    @if ($errors->hasAny(['current_password','password', 'password_confirmation','new_password','validation.password']))
                        <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
                        <ul class="list-ticked">
                            @foreach ($errors->all() as $error)
                                <li class="text-danger">{{ $error }}</li>
                            @endforeach
                        </ul>
                    @endif
                    <form method="POST" action="{{ route('change.password') }}">
                        @csrf
                        <p >La nueva contraseña debe tener al menos 8 caracteres, mayúsculas, minúsculas, números y simbolos</p>
                        <div class="row mb-3 {{ $errors->has('current_password') ? 'has-error' : '' }}">
                            <label for="current_password" class="col-md-4 col-lg-3 col-form-label">Contraseña Actual</label>
                            <div class="col-md-8 col-lg-9">
                                <input name="current_password" type="password" class="form-control" id="current_password">
                            </div>
                        </div>
                        <div class="row mb-3 {{ $errors->has('new_password') ? 'has-error' : '' }}">
                            <label for="new_password" class="col-md-4 col-lg-3 col-form-label">Nueva Constraseña</label>
                            <div class="col-md-8 col-lg-9">
                                <input name="new_password" type="password" class="form-control" id="new_password">
                            </div>
                        </div>
                        <div class="row mb-3">
                            <label for="renewPassword" class="col-md-4 col-lg-3 col-form-label">Confirmar Nueva Constraseña</label>
                            <div class="col-md-8 col-lg-9">
                                <input type="password" name="new_password_confirmation" id="new_password_confirmation" class="form-control" >
                                <small id="passwordHelpBlock" class="form-text text-muted">
                                    <span id="passwordMatch"></span>
                                </small>
                            </div>
                        </div>
                        <div class="text-center">
                            <button type="submit" class="btn btn-primary btn-round">Cambiar Contraseña</button>
                        </div>
                    </form><!-- End Change Password Form -->
                </div>
              </div><!-- End Bordered Tabs -->
            </div>
          </div>
        </div>
      </div>
</div>
@endsection
@section('scripts')

<script src="{{ asset('assets/js/forms/users.js') }}" type="text/javascript"></script>
<script>
  $(document).ready(function () {
      $('#new_password, #new_password_confirmation').on('input', function () {
          if ($('#new_password').val() == $('#new_password_confirmation').val()) {
              $('#passwordMatch').html('Las contraseñas coinciden').css('color', 'green');
          } else {
              $('#passwordMatch').html('Las contraseñas no coinciden').css('color', 'red');
          }
      });
  });
</script>
@endSection