@extends('admin.layouts.app_admin')
@section('titulo','Editar Usuario')

@section('content')

<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Editar Usuario</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Configuración Accesso</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="{{ route('users.index') }}">Usuarios</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Editar Usuario</a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Datos del Usuario</h4>
                </div>
                <div class="card-body">
                {!! Form::model($user,['route'=>['users.update',$user->id],'method'=>'PUT','class'=>'needs-validation']) !!}
                    @include('admin.users._form',['texto' => 'Actualizar','tipo'=>'2','texto_pass'=>'Cambiar Contraseña','color'=>'success'])
                {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@section('scripts')
<script src="{{ asset('assets/js/forms/users.js') }}" type="text/javascript"></script>
@endsection



