
@extends('admin.layouts.app_admin')
@section('titulo','Unidades')
@section('content')

<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Unidades</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Áreas y Unidades</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Unidades</a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <h4 class="card-title">Unidades registradas hasta la fecha</h4>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="table-responsive">
                                <table class="table table-hover table-sm" id="datos" >
                                    <thead>
                                        <tr>
                                            <th class="text-center">Código</th>
                                            <th class="text-center">Nombre</th>
                                            <th class="text-center">Área</th>
                                            <th class="text-center">Acciones</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($unidades as $unidad)
                                            <tr>
                                                <td class="text-center">{{$unidad->codigo}}</td>
                                                <td class="text-left">{{$unidad->nombre}}</td>
                                                <td class="text-left">@if($unidad->area != null){{$unidad->area->nombre}} @endif</td>
                                                <td class="d-flex align-items-center justify-content-center">
                                                    @can('unidades.edit')
                                                        <a href="{{ route('unidades.edit', $unidad) }}"  title="Editar datos" data-toggle="tooltip"><button class="btn btn-warning btn-icon btn-round"><i class="fas fa-edit"></i></button></a>
                                                    @endcan
                                                    @can('unidades.destroy')
                                                        <form action="{{ route('unidades.destroy', $unidad) }}" method="POST" style="display: inline-block;" class="form-eliminar">
                                                            @csrf
                                                            @method('DELETE')
                                                            <button type="button" class="btn btn-danger btn-icon btn-round btn-eliminar" onclick="return confirm('¿Está seguro que desea ELIMINAR la UNIDAD?');" data-toggle="tooltip" data-placement="bottom" title="Eliminar Registro">
                                                                <i class="fas fa-trash-alt"></i>
                                                            </button>
                                                        </form>
                                                    @endcan
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')
    <script src="{{asset('assets/js/tablas/basica.js')}}"></script>
<script>
document.addEventListener('DOMContentLoaded', function () {
    // Usa delegación para botones dentro de la tabla
    document.body.addEventListener('click', function (e) {
        if (e.target.closest('.btn-eliminar')) {
            e.preventDefault();

            const button = e.target.closest('.btn-eliminar');
            const form = button.closest('form');

             Swal.fire({
                title: "Eliminado!",
                text: "La UNIDAD fue ELIMINADA correctamente.",
                icon: "success",
                timer: 2000,
                // timerProgressBar: true,
                // showConfirmButton: true
            }).then(() => {
                form.submit(); // se envía recién después de que se muestra el mensaje
                location.reload();
            });
        }
    });
});
</script>


@endsection