@extends('admin.layouts.app_admin')
@section('titulo','Agregar sitio web')
@section('content')

<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Nuevo Sitio Web</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Sitios Web de Interes</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Nuevo Sitio Web</a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-body">
                    {!! Form::open(['route'=>'sitios_web.store','class'=>'form-horizontal','id'=>"form-menu"]) !!}
                        @include('admin.sitios_web._form',['texto' => 'Registrar','color'=>'primary'])
                    {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
@section('scripts')
<script>
    document.getElementById('form-menu').addEventListener('submit', function(e) {
        e.preventDefault(); // evita el envío inmediato del formulario
    
        const name = document.getElementById('name').value.trim();
        const url = document.getElementById('url').value.trim();
    
        if (!name || !url) {
            Swal.fire('Campos obligatorios', 'Debe completar el nombre y la URL', 'warning');
            return;
        }
    
        Swal.fire({
            title: '¿Desea guardar este SITIO WEB?',
            html: `<strong>Nombre:</strong> ${name}<br><strong>URL:</strong> ${url}`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'Sí, guardar',
            cancelButtonText: 'Cancelar',
            reverseButtons: true
        }).then((result) => {
            if (result.isConfirmed) {
                e.target.submit(); // si se confirma, envía el formulario
            }
        });
    });
    </script>
    
@endsection