
@extends('admin.layouts.app_admin')
@section('titulo','Roles')
@section('content')

<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Roles</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Configuración Acceso</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Roles</a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex align-items-center justify-content-between">
                        <h4 class="card-title">Listado de roles registrados</h4>
                        @can('roles.create')
                            <a href="{{ route('roles.create') }}" class="btn btn-primary btn-round">Crear Nuevo Rol</a>
                        @endif
                    </div> 
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover  table-sm">
                            <thead>
                                <tr>
                                    <th class="text-center">Rol</th>
                                    <th class="text-center ">Descripción</th>
                                    <th class="text-center" >Acciones</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach($roles as $role)
                                    <tr>
                                        <td class="fw-bold">{{$role->name}}</td>
                                        <td class="text-wrap">{{$role->descripcion}}</td>
                                        <td>
                                            <div class="d-flex justify-content-center">
                                                @can('roles.show')
                                                    <a href="{{route('roles.show',$role->id)}}" data-toggle="tooltip" title="Ver los permisos asignados al rol"><button class="btn btn-secondary btn-icon btn-round "><i class="fas fa-eye"></i></button></a>
                                                @endcan
                                                @can('roles.edit')
                                                    <a href="{{route('roles.edit',$role->id)}}" data-toggle="tooltip" title="Modificar Permisos asignados al rol" ><button class="btn btn-warning btn-icon btn-round "><i class="fas fa-edit"></i></button></a>
                                                @endcan
                                                @can('roles.destroy')
                                                    {!! Form::open(['route'=>['roles.destroy',$role->id],'method'=>'DELETE']) !!}
                                                        <button class="btn btn-danger btn-icon btn-round " data-toggle="tooltip" title="Eliminar rol" onclick="return confirm('¿Está seguro que desea eliminar el rol? Los usuarios con el ROL perderan el acceso al sistema');"><i class="fas fa-trash-alt"></i></button>
                                                    {!! Form::close() !!}
                                                @endcan
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

</div>

 @endsection