<p>Debe rellenar todos los campos.</p>
@if ($errors->any())
    <h5 class="text-danger">CORRIJA ESTOS ERRORES:</h5>
    <ul class="list-ticked">
        @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
        @endforeach
    </ul>
@endif
<div class="form-group row {{ $errors->has('name') ? 'has-error' : '' }}">
        <label for="name" class="col-lg-3 col-md-3 col-xs-12 col-form-label text-right ">Nombre rol<span class="text-danger text-bold">(*)</span></label>
    <div class="col-lg-7 col-md-7 col-xs-12">
        <input type="text" class="form-control @error('name') error @enderror" name="name" id="name" value="{{ old('name',$role->name) }}">
    </div>
</div>

<div class="form-group row {{ $errors->has('descripcion') ? 'has-error' : '' }}">
    <label for="descripcion" class="col-lg-3 col-md-3 col-xs-12 col-form-label text-right">Descripción<span class="text-danger text-bold">(*)</span></label>
    <div class="col-lg-9 col-md-9 col-xs-12">
        <input type="text" class="form-control @error('descripcion') error @enderror" name="descripcion" id=descripcion value="{{ old('descripcion',$role->descripcion) }}">
    </div>
</div>

<hr>
<h2 >Lista de Permisos</h2>
<p class="mb-0">Los permisos se encuentran agrupados por cada sección del intranet, solo debe presionar sobre el nombre del grupo para abrir el contenido del grupo y escoger los permisos que quiere asignar.</p>
<p>Marque los permisos que quiere asignar al Rol y luego presione el boton <strong>GUARDAR</strong></p>
<!-- Accordion without outline borders -->
<div class="row">
    <div class="col-md-6">
        <div class="accordion" id="accordionExample">
            @foreach($grupos as $cont_grupo=>$grupo)
            <div class="card mb-0">
              <div class="card-header pb-0" id="headingOne">
                  <div class="d-flex justify-content-between">
                  <a class="btn btn-link text-left" type="button" data-toggle="collapse" data-target="#collapseOne-{{ $cont_grupo }}" aria-controls="collapseOne-{{ $cont_grupo }}">
                        <h3 class="mb-0">
                            {{ $grupo->grupo }} <span class="caret"></span>
                        </h3>
                    </div> 
                </a>
                <div class="badge badge-warning" id="contador-{{ $cont_grupo }}"></div>
              </div>
          
              <div id="collapseOne-{{ $cont_grupo }}" class="collapse" aria-labelledby="headingOne" data-parent="#accordionExample">
                <div class="card-body">
                    <div class="form-check pb-0 pt-0">
                        <label class="form-check-label">
                            {{ Form::checkbox('marcar_todo_'.$grupo->grupo, null, false, ['class' => 'form-check-input marcar-todos', 'data-grupo' => $cont_grupo]) }}
                            <span class="form-check-sign">MARCAR / DESMARCAR TODOS</span>
                        </label>
                    </div>
                    <?php $cont=0; ?>
                    @foreach($permissions as $permission)
                        @if($permission->grupo==$grupo->grupo)
                        <?php $cont=$cont+1; ?>
                        <div class="form-check pb-0 pt-0">
                            <label class="form-check-label">
                                {{ Form::checkbox('permissions[]', $permission->id, null, ['class' => 'form-check-input permission-checkbox', 'id' => 'basic_checkbox_' . $cont, 'data-grupo' => $cont_grupo]) }}
                                <span class="form-check-sign">{{$permission->descripcion ?: 'Sin descripción'}} <em>({{$permission->name}})</em></span>
                            </label>
                        </div>
                        @endif
                    @endforeach
                </div>
              </div>
            </div>
            @endforeach
        </div>
    </div>
    <div class="col-md-6">
        <h2>Permisos asignados</h2>
        <ul class="list-unstyled">
            @forelse($role->permissions as $permission)
            <li>
                <label>
                    <strong>{{$permission->descripcion ?: 'Sin descripción'}}</strong>
                    <em>({{$permission->name}})</em>
                </label>
            </li>
            @empty
            <li>
                <label>
                    Sin Permisos Asignados
                </label>
            </li>
            @endforelse
        </ul>
    </div>
</div>


<div class="form-group text-center">

    {{ Form::submit('Guardar',['class'=>'btn btn-primary btn-round']) }}
    <a href="javascript:history.back()" class="btn btn-warning btn-round">Cancelar</a>

</div>
