@extends('admin.layouts.app_admin')
@section('titulo','Administración Noticias')
@section('content')

<div class="page-inner">
  <div class="page-header">
    <h4 class="page-title">Administración de Noticias</h4>
    <ul class="breadcrumbs">
      <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
      <li class="separator"><i class="flaticon-right-arrow"></i></li>
      <li class="nav-item"><a href="javascript:void(0)">Administración de Contenidos</a></li>
      <li class="separator"><i class="flaticon-right-arrow"></i></li>
      <li class="nav-item"><a href="javascript:void(0)">Noticias y Anuncios</a></li>
      <li class="separator"><i class="flaticon-right-arrow"></i></li>
      <li class="nav-item"><a href="javascript:void(0)">Ver Registrados</a></li>
    </ul>
  </div>
  <div class="row">
      <div class="col-lg-12">
          <div class="card">
              <div class="card-header">
                  <div class="d-flex align-items-center justify-content-between">
                    <h4 class="card-title">Noticias y Anuncios registrados</h4>
                    @can('noticias.create')
                      <a href="{{ route('noticias.create') }}" class="btn btn-primary btn-round">Registrar Nuevo</a>
                    @endif
                  </div>
              </div>
              <div class="card-body">
                <div class="tab-content">
                   @livewire('admin.noticia-component',['seccion'=>$seccion])
                </div>
              </div>
          </div>
      </div>
  </div>

</div>
@endsection
