
<p>Los campos marcados con <strong class="text-danger">(*)</strong> son obligatorios.</p>
@if ($errors->any())
    <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
    <ul class="list-ticked">
        @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
        @endforeach
    </ul>
@endif
<div class="row">
    <div class="col-md-2 pr-0">
        <div class="form-group pb-0 {{ $errors->has('fecha') ? 'has-error' : '' }}">
            <label for="">Fecha Publicación <span class="text-danger">(*)</span></label>
            <input type="date" name="fecha" id="fecha" class="form-control" value="{{ old('fecha',$noticia->fecha == null ? date('Y-m-d') : $noticia->fecha) }}">
        </div>
    </div>
    <div class="col-md-4 pr-0">
        <div class="form-group pb-0 {{ $errors->has('contenido_tipo_id') ? 'has-error' : '' }}">
            <label for="">Tipo de Contenido <span class="text-danger">(*)</span></label>
            <select name="contenido_tipo_id" id="tipo" class="form-control">
                <option value="">-- SELECCIONE --</option>
                @foreach ($tipos as $t)
                    <option value="{{ $t->id }}" {{ old('contenido_tipo_id',$noticia->contenido_tipo_id) == $t->id ? 'selected' : '' }}>{{ $t->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>
    @if(auth()->user()->unidad_id == null || auth()->user()->rol[0]->id==3)
    <div class="col-md-6">
        <div class="form-group pb-0 {{ $errors->has('unidad_id') ? 'has-error' : '' }}">
            <label for="">Referencia a Unidad Institucional <span class="text-danger">(*)</span></label>
            <select name="unidad_id" id="unidad_id" class="form-control">
                <option value="">-- BUSQUE Y SELECCIONE --</option>
                @foreach ($unidades as $unidad)
                    <option value="{{ $unidad->id }}" {{ old('unidad_id',$noticia->unidad_id) == $unidad->id ? 'selected' : '' }}>{{ $unidad->codigo }} - {{ $unidad->nombre }}</option>
                @endforeach
            </select>
        </div>
    </div>
    @endif
</div>
<div class="row">
    <div class="col-md-4">
        <div class="form-group pb-0 {{ $errors->has('visible') ? 'has-error' : '' }}">
            <div class="form-check">
                <label>Publicación visible<span class="text-danger">(*)</span></label><br/>
                <label class="form-radio-label">
                    <input class="form-radio-input" type="radio" name="visible" value="1" {{ old('visible', isset($noticia) && $noticia->exists ? $noticia->visible : '')==1 ? 'checked' : '' }}>
                    <span class="form-radio-sign">Para Todos</span>
                </label>
                <label class="form-radio-label ml-3">
                    <input class="form-radio-input" type="radio" name="visible" value="0" {{ old('visible', isset($noticia) && $noticia->exists ? $noticia->visible : '')==0 ? 'checked' : '' }}>
                    <span class="form-radio-sign">Solo para la Unidad</span>
                </label>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-4"></div>
</div>
<div class="row">
    <div class="col-md-12">
        <div class="form-group pb-0 {{ $errors->has('titulo') ? 'has-error' : '' }}">
            <label for="">Título <span class="text-danger">(*)</span></label>
            <input type="text" name="titulo" id="titulo" class="form-control" value="{{ old('titulo',$noticia->titulo) }}" onkeyup="javascript:this.value=this.value.toUpperCase();">
        </div>
    </div>
</div>
<div class="row">
    <div class="col-md-8">
        <div class="form-group pb-0 {{ $errors->has('descripcion') ? 'has-error' : '' }}">
            <label for="">Descripción <span class="text-danger">(*)</span></label>
            <textarea name="descripcion" id="descripcion" cols="30" rows="10" class="form-control">{{ old('descripcion',$descripcion) }}</textarea>
        </div>
    </div>
    <div class="col-md-4">
        <div class="form-group pb-0 {{ $errors->has('adjunto') ? 'has-error' : '' }}">
            <label for="adjunto" >Adjuntar Fotografia <span class="text-danger">(*)</span></label>
            <input type="file" name="adjunto" id="adjunto" class="form-control" accept="image/*" >
            @if($noticia->adjunto!=null)
            <a href="{{ asset('adjuntos/'.$noticia->adjunto) }}" target="_blank" class="btn btn-info">Ver Adjunto</a>
            @endif
        </div>
        <div id="preview">
            
        </div>
    </div>
</div>
<div class="form-check">
    <label class="form-check-label">
        <input class="form-check-input" type="checkbox" value="1" name="estado" {{ old('estado',$noticia->estado) == 1 ? 'checked' : '' }}>
        <span class="form-check-sign">Marcar si quiere publicar el contenido</span>
    </label>
</div>
<div class="text-center">
    <button class="btn btn-{{ $color }} btn-rounded">{{ $texto }}</button>
    <a href="{{ route('noticias.index') }}" class="btn btn-warning btn-rounded">Salir</a>
</div>