<ul class="list-group list-group-flush">
    @foreach($menuItems as $item)
        <li class="list-group-item">
            <div class="d-flex justify-content-between align-items-center">
                <span>{{ $item->name }} ({{ $item->url ?: 'Sin URL' }})</span>
                <div>
                    <a href="{{ route('menu.edit', $item) }}" class="btn btn-sm btn-warning btn-rounded">Editar</a>
                    <form action="{{ route('menu.destroy', $item) }}" method="POST" style="display: inline-block;">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger btn-rounded" onclick="return confirm('¿Estás seguro?')">Eliminar</button>
                    </form>
                </div>
            </div>
            @if($item->children->isNotEmpty())
                @include('menu.partials.menu-items', ['menuItems' => $item->children])
            @endif
        </li>
    @endforeach
</ul>