@extends('admin.layouts.app_admin')
@section('titulo','Menú de Opciones')
@section('content')

<div class="page-inner">
  <div class="page-header">
    <h4 class="page-title">Ver Menú</h4>
    <ul class="breadcrumbs">
        <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
        <li class="separator"><i class="flaticon-right-arrow"></i></li>
        <li class="nav-item"><a href="javascript:void(0)">Menú de Opciones</a></li>
        <li class="separator"><i class="flaticon-right-arrow"></i></li>
        <li class="nav-item"><a href="javascript:void(0)">Ver Menú</a></li>
    </ul>
  </div>
  <div class="row">
      <div class="col-lg-12">
          <div class="card">
              <div class="card-header">
                  <div class="d-flex align-items-center justify-content-between">
                    <h4 class="card-title">Opciones que se muestran al ingresar al intranet</h4>
                    @can('menus.create')
                      <a href="{{ route('menu.create') }}" class="btn btn-primary btn-round">Agregar Nueva Opción</a>
                    @endif
                  </div>
              </div>
              <div class="card-body">
                <div class="table-responsive">
                  <table class="table table-hover table-sm" id="datos">
                    <thead>
                      <th class="text-center">Nombre</th>
                      <th class="text-center">URL</th>
                      <th class="text-center">Orden</th>
                      <th class="text-center">Acciones</th>
                    </thead>
                    <tbody>
                      @foreach($menuItems as $menu)
                        <tr>
                          <td class="text-left">{{ $menu->name }}</td>
                          <td class="text-left">@if($menu->parent_id != null){{ $menu->parent->url }} / @endIf {{ $menu->url }}</td>
                          <td class="text-center">{{ $menu->order }}</td>
                          <td class="text-center">
                            @can('menus.edit')
                                <a href="{{ route('menu.edit', $menu) }}"  title="Editar datos" data-toggle="tooltip"><button class="btn btn-warning btn-icon btn-round"><i class="fas fa-edit"></i></button></a>
                            @endcan
                            @can('menus.destroy')
                                <form action="{{ route('menu.destroy', $menu) }}" method="POST" style="display: inline-block;">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-danger btn-icon btn-round" data-toggle="tooltip" onclick="return confirm('¿Está seguro que desea eliminar el registro?');"><i class="fas fa-trash-alt"></i></button>
                                </form>
                            @endcan
                          </td>
                        </tr>
                      @endforeach
                    </tbody>
                  </table>
                </div>
              </div>
          </div>
      </div>
  </div>

</div>
@endsection
@section('scripts')
<script src="{{asset('assets/js/tablas/basica.js')}}"></script>
@endSection