@extends('admin.layouts.app_admin')
@section('titulo','Administración Empleados')
@section('content')

<div class="page-inner">
  <div class="page-header">
    <h4 class="page-title">Administración de Empleados Registrados en el Intranet</h4>
    <ul class="breadcrumbs">
        <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
        <li class="separator"><i class="flaticon-right-arrow"></i></li>
        <li class="nav-item"><a href="javascript:void(0)">Administrar Empleados</a></li>
        <li class="separator"><i class="flaticon-right-arrow"></i></li>
        <li class="nav-item"><a href="javascript:void(0)">Ver Registrados</a></li>
    </ul>
  </div>
  <div class="row">
      <div class="col-lg-12">
          <div class="card">
              <div class="card-header">
                  <div class="d-flex align-items-center justify-content-between">
                    <h4 class="card-title">Empleados registrados</h4>
                    
                    @can('empleados.create')
                      <a href="{{ route('empleados.create') }}" class="btn btn-primary btn-round">Agregar Nuevo</a>
                    @endif
                  </div>
              </div>
              <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover" id="datos_order">
                        <thead>
                            <tr>
                                <th class="text-center">Nombre Completo</th>
                                <th class="text-center">Cumpleaños</th>
                                <th class="text-center">Cargo</th>
                                <th class="text-center">Unidad</th>
                                <th class="text-center">Area</th>
                                <th class="text-center">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($empleados as $empleado)
                                <tr>
                                    <td class="text-left">{{ $empleado->nombre }}</td>
                                    <td class="text-center">{{ date('d/m/Y',strtotime($empleado->fecha_nacimiento)) }}</td>
                                    <td class="text-center">{{ $empleado->cargo }}</td>
                                    <td class="text-center">{{ $empleado->unidad->nombre }}</td>
                                    <td class="text-center">@if($empleado->unidad->area!= null){{$empleado->unidad->area->nombre}} @else {{ $empleado->area }} @endif</td>
                                    <td class="text-center">
                                        <div class="d-flex align-items-center justify-content-center">
                                            @can('empleados.edit')
                                            <a href="{{ route('empleados.edit', $empleado) }}"  title="Editar datos" data-toggle="tooltip"><button class="btn btn-warning btn-icon btn-round"><i class="fas fa-edit"></i></button></a>
                                            @endcan
                                            @can('empleados.destroy')
                                            <form action="{{ route('empleados.destroy', $empleado) }}" method="POST" style="display: inline-block;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="submit" class="btn btn-danger btn-icon btn-round" data-toggle="tooltip" title="Eliminar Registro" onclick="return confirm('¿Está seguro que desea eliminar el registro?');"><i class="fas fa-trash-alt"></i></button>
                                            </form>
                                            @endcan
                                        </div>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
              </div>
          </div>
      </div>
  </div>

</div>
@endsection
@section('scripts')
    <script src="{{asset('assets/js/tablas/basica.js')}}"></script>
@endsection