<p class="mb-0">Los campos marcados con <strong class="text-danger">(*)</strong> son obligatorios.</p>
<P>Del listado <strong>Funcionario SEDEM/EPPs</strong> puede obtener los datos de la persona a la cual quiere agregar al directorio, en caso de que no se encuentre en la lista puede agregar directamente el <strong>NOMBRE Y CARGO</strong> correspondiente.</P>
</p>
@if ($errors->any())
    <ul class="list-ticked">
        @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
        @endforeach
    </ul>
@endif

<div class="row mb-2 {{ $errors->has('nombre_completo') ? 'has-error' : '' }}"" >
    <label for="nombre_completo" class="col-md-4 col-form-label text-right">Funcionario SEDEM/EPPs </label>
    <div class="col-md-8">
        <select name="empleado_ci" id="empleado_ci" class="form-control" data-ruta="{{ route('admin.empleados.search') }}">
            <option value="">-- BUSQUE Y SELECCIONE --</option>
            @foreach($empleados as $empleado)
                <option value="{{$empleado->ci}}" {{ old('empleado_ci', $directorio->empleado_ci)== $empleado->ci ? 'selected' : '' }}>{{ $empleado->ci }} - {{ $empleado->nombre }} - {{ $empleado->cargo }} - {{ $empleado->unidad }} </option>
            @endforeach
        </select>
    </div>
</div>
<div class="row mb-2 {{ $errors->has('nombre') ? 'has-error' : '' }}">
    <label for="nombre" class="col-md-4 col-form-label text-right">Nombre Completo Persona <span class="text-danger">(*)</span> <br> </label>
    <div class="col-md-8">
        <input type="text" class="form-control" id="nombre" name="nombre" value="{{  old('nombre',$directorio->nombre) }}" onkeyup="javascript:this.value=this.value.toUpperCase();">
        <small>(Si no hace referencia a un funcionario del sedem)</small>
    </div>
</div>
<div class="row mb-2 {{ $errors->has('cargo') ? 'has-error' : '' }}">
    <label for="cargo" class="col-md-4 col-form-label text-right">Cargo <span class="text-danger">(*)</span></label>
    <div class="col-md-8">
        <input type="text" class="form-control" id="cargo" name="cargo" value="{{  old('cargo',$directorio->cargo) }}" onkeyup="javascript:this.value=this.value.toUpperCase();">
    </div>
</div>

<div class="row mb-1 {{ $errors->has('area_id') ? 'has-error' : '' }}">
    <label for="area_id" class="col-md-4 col-form-label text-right">Área de dependencia: </label>
    <div class="col-md-8 mb-0 pb-0">
        <select name="area_id"  class="form-control {{ $errors->has('area_id') ? ' form-control-danger' : '' }}" id="area_id"  data-ruta="{{ route('unidades.listar') }}">
            <option value="">--BUSQUE Y SELECCIONE--</option>
            @foreach($areas as $area)
                @if($directorio->unidad_id != null)
                    <option value="{{$area->id}}" {{ old('area_id', $directorio->unidad->area_id  )== $area->id ? 'selected' : '' }}>{{ $area->codigo }} - {{ $area->nombre }}</option>
                @else
                    <option value="{{$area->id}}" {{ old('area_id') == $area->id ? 'selected' : '' }}>{{ $area->codigo }} - {{ $area->nombre }}</option>
                @endif
            @endforeach
        </select>
    </div>
</div>
<div class="row mb-1 {{ $errors->has('unidad_id') ? 'has-error' : '' }}">
    <label for="unidad_id" class="col-md-4 col-form-label text-right">Unidad: </label>
    <div class="col-md-7 mb-0 pb-0">
        <select name="unidad_id" class="form-control {{ $errors->has('unidad_id') ? ' form-control-danger' : '' }}" id="unidad_id" data-old="{{ old('unidad_id', $directorio->unidad_id) }}">
            <option value="">--BUSQUE Y SELECCIONE--</option>
        </select>
    </div>
    <div class="col-md-1">
        <button type="button" class="btn btn-primary btn-sm" id="actualizar-unidades" title="Actualizar Unidades">
            <i class="fas fa-sync"></i>
        </button>
    </div>
</div>
<div class="row mb-2 {{ $errors->has('interno') ? 'has-error' : '' }}">
    <label for="interno" class="col-md-4 col-form-label text-right">Interno <span class="text-danger">(*)</span></label>
    <div class="col-md-4 ">
        <input type="number" class="form-control" id="interno" name="interno" value="{{  old('interno',$directorio->interno) }}" >
    </div>
</div>
<div class="text-center">
    <button class="btn btn-{{ $color }} btn-rounded">{{ $texto }}</button>
    <a href="{{ route('directorio_empleados.index') }}" class="btn btn-warning btn-rounded">Salir</a>
</div>