@extends('admin.layouts.app_admin')
@section('titulo','Clasificadores - Tipo Contenido')
@section('content')
    
<!--img-fondo-admin-->
<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Tipo de Contenido</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Clasificadores</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Ver Todos</a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-md-10">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex align-items-center justify-content-between">
                        <div>
                            <div class="card-title">Tipos de contenidos registrados</div>
                            <div class="card-category">El tipo de contenido permite clasificar los documentos internos y documentos generales que se registran en el sistema.</div>
                        </div>
                        @can('tipo_contenidos.create')
                          <a href="javascript:void(0)" class="btn btn-primary btn-round" data-toggle="tooltip" title="agregar un nuevo tipo de contenido" onclick="create();">Agregar Nuevo</a>
                        @endif
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-hover" id="datos">
                            <thead>
                                <tr>
                                    <th class="text-center">Nombre</th>
                                    <th class="text-center">Tipo Documento</th>
                                    <th class="text-center">Acciones</th>
                                </tr>
                                <tr>
                                    <td></td>
                                    <td></td>
                                    <td></td>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@include('admin.clasificadores.tipo_contenido._crud')
 @endsection
 @section('scripts')
 <script>
    $('.tipoFiltro').select2();
    var e = @json(auth()->user()->can('tipo_contenidos.edit'));
    var d= @json(auth()->user()->can('tipo_contenidos.destroy'));
</script>
 <script src="{{asset('assets/js/forms/clasificador/crudTipoContenido.js')}}"></script>
 @endsection