
@extends('admin.layouts.app_admin')
@section('titulo','Áreas')
@section('content')

<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Áreas</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Áreas y Unidades</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Áreas</a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex align-items-center justify-content-between">
                        <h4 class="card-title">Areas registrados hasta la fecha</h4>
                        @can('areas.create')<a href="{{ route('areas.create') }}" class="btn btn-primary btn-round mr-2">Agregar Nueva Area</a>@endcan
                    </div>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <div class="table-responsive">
                                <table width="100%" id="datos" class="table table-hover table-sm">
                                    <thead>
                                        <tr>
                                            <th class="text-center">Nombre Area</th>
                                            <th class="text-center">Nro de Unidades Dependientes</th>
                                            <th class="text-center"></th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        @foreach($areas as $area)
                                            <tr>
                                                <td>{{$area->nombre}}</td>
                                                <td class="text-center"><span class="badge badge-warning">Unidades: <strong>{{$area->unidades->count()}}</strong></span></td>
                                                <td class="text-center">
                                                    
                                                    <button class="btn btn-default btn-round dropdown-toggle" type="button" data-toggle="dropdown"> 
                                                    OPCIONES
                                                    </button>
                                                    <ul class="dropdown-menu" role="menu">
                                                        <li>
                                                            @can('areas.edit')
                                                                <a class="dropdown-item" href="{{ route('areas.edit', $area) }}" href="#">Modificar Datos</a>
                                                                
                                                            @endcan
                                                        </li>
                                                        <li>
                                                            @can('areas.destroy')
                                                                <form action="{{ route('areas.destroy', $area) }}" method="POST" >
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <button type="submit" class="dropdown-item text-danger" onclick="return confirm('¿Está seguro que desea ELIMINAR EL AREA?');">Eliminar</button>
                                                                </form>
                                                            @endcan
                                                        </li>
                                                    </ul>
                                                </td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

@endsection
@section('scripts')
 <script src="{{asset('assets/js/tablas/basica.js')}}"></script>
@endsection