@extends('admin.layouts.app_admin')
@section('titulo','Editar Área')

@section('content')

<div class="page-inner">
    <div class="page-header">
        <h4 class="page-title">Editar Área</h4>
        <ul class="breadcrumbs">
            <li class="nav-home"><a href="{{ route('home') }}"><i class="flaticon-home"></i></a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Áreas y Unidades</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="{{ route('users.index') }}">Áreas</a></li>
            <li class="separator"><i class="flaticon-right-arrow"></i></li>
            <li class="nav-item"><a href="javascript:void(0)">Editar Área</a></li>
        </ul>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex align-items-center justify-content-between">
                        <h4 class="card-title">Datos del Área</h4>
                        @can('areas.create')<a href="{{ route('areas.create') }}" class="btn btn-primary btn-round mr-2">Agregar Nueva Area</a>@endcan
                    </div>
                </div>
                <div class="card-body">
                {!! Form::model($area,['route'=>['areas.update',$area->id],'method'=>'PUT','class'=>'needs-validation']) !!}
                    @include('admin.areas._form',['texto' => 'Actualizar','color'=>'success'])
                {!! Form::close() !!}
                </div>
            </div>
        </div>
    </div>
    <div class="row mt--2">
        <div class="col-lg-12">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex align-items-center justify-content-between">
                        <h4 class="card-title">Administrar Unidades del Area</h4>
                        @can('unidades.create')
                        <button class="btn btn-primary btn-round" onclick="create();">Agregar Nueva Unidad</button>
                        @endcan
                    </div>
                </div>
                <div class="card-body">
                    <div class="text-left mb-3">
                        <h1>Listado de Unidades dependientes del área <strong class="badge badge-warning">{{ $area->unidades->count() }}</strong> </h1>
                    </div>
                    
                    <input type="hidden" value="{{ auth()->user()->can('unidades.destroy') }}" id='can_destroy'>
                    <input type="hidden" value="{{ auth()->user()->can('unidades.edit') }}" id='can_edit'>
                    <input type="hidden" value="{{ $area->id }}" id='area_id'>
                    <input type="hidden" value="{{ $area->codigo }}" id='area_codigo'>
                    <p>En campo <strong>ORDEN</strong> se utiliza para ordenar las unidades dependientes dentro del área al momento de mostrar el directorio de empleados</p>
                    <div class="table-responsive" width="100%">
                        <table class="table table-hover table-sm" id="datos">
                            <thead>
                                <tr>
                                    <th class="text-center">Código</th>
                                    <th class="text-center">Nombre</th>
                                    <th class="text-center">Área</th>
                                    <th class="text-center">Orden</th>
                                    <th class="text-center">Acciones</th>
                                </tr>
                            </thead>
                            <tbody></tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@include('admin.areas._modal_unidad')
@endsection
@section('scripts') 
    <script src="{{asset('assets/js/forms/crudUnidades.js')}}"></script>
@endsection