var _modal2 = $('#newTipoContenido');
var _modalGrupo = $('#newGrupo');
var csrf = $('input[name="_token"]').val();
var adminUrl=url_global;
$.ajaxSetup({
    headers: {'X-CSRF-Token': csrf}
});

function reset(modal) {
    modal.find('input').each(function () {
        $(this).val(null)
    })

};
_modal2.on('shown.bs.modal', function () {
    $('#nombreTipo').trigger('focus')
})

_modalGrupo.on('shown.bs.modal', function () {
    $('#nombreGrupo').trigger('focus')
})

$(document).on('submit', '#storeTipoContenido', function(event) {
	event.preventDefault();
    var nombre=$('#nombreTipo').val();
    var menu_id = $('#menu_id').val();
    var tipo=$('#tipo').data('tipo');
    Swal.fire({
        title: "Desea Continuar?",
        text: "Agregara un Tipo de Contenido!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Si, Registrar!",
        cancelButtonText:'Cancelar'
      }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                method: 'POST',
                url: adminUrl + '/tipo_contenidos/store',
                data: {nombre:nombre,tipo:'contenido',menu_item_id:menu_id},
                dataType: 'JSON',
                success: function (respuesta)
                { 
                    reset(_modal2)
                    $('#newTipoContenido').hide();
                    $('.modal-backdrop').remove();
                    $('body').removeClass('modal-open');
                    var html_select='<option value="">-- BUSQUE Y SELECCIONE --</option>';
                    for(var i=0; i<respuesta.length; ++i){
                        html_select+='<option value="'+respuesta[i].id+'"'+ (nombre==respuesta[i].nombre ? 'selected' : '') +'>'+respuesta[i].nombre+'</option>'
                    }
                    $('#tipo').html(html_select);
                    $("#tipo").trigger("chosen:updated");
                    $('#error').html('');
                    $('#seccionTipo').removeClass('has-error');
                    Swal.fire({
                        text: "El tipo de contenido fue registrado correctamente! y se actualizo la lista",
                        icon: "success"
                    });
                },
                error: function (data) {
                    var e=data.responseJSON;
                    var errores=e.errors
                    if(errores.nombre != undefined){
                        $('#error').html(e.errors.nombre);
                        $('#seccionTipo').addClass('has-error');
                    }
                    
                }
        
            })
        }
      });
});

$(document).on('submit', '#storeGrupo', function(event) {
	event.preventDefault();
    var nombre=$('#nombreGrupo').val();
    Swal.fire({
        title: "Desea Continuar?",
        text: "Agregara un Grupo!",
        icon: "warning",
        showCancelButton: true,
        confirmButtonColor: "#3085d6",
        cancelButtonColor: "#d33",
        confirmButtonText: "Si, Registrar!",
        cancelButtonText:'Cancelar'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                method: 'POST',
                url: adminUrl + '/grupos/store',
                data: {nombre:nombre,tipo:'grupo'},
                dataType: 'JSON',
                success: function (respuesta)
                { 
                    reset(_modalGrupo);
                    $('#newGrupo').hide();
                    $('.modal-backdrop').remove();
                    $('body').removeClass('modal-open');
                    var html_select='<option value="">-- BUSQUE Y SELECCIONE --</option>';
                    for(var i=0; i<respuesta.length; ++i){
                        html_select+='<option value="'+respuesta[i].id+'"'+ (nombre==respuesta[i].nombre ? 'selected' : '') +'>'+respuesta[i].nombre+'</option>'
                    }
                    $('#grupo_id').html(html_select);
                    $("#grupo_id").trigger("chosen:updated");
                    $('#errorGrupo').html('');
                    $('#seccionGrupo').removeClass('has-error');
                    Swal.fire({
                        text: "El Grupo fue registrado correctamente! y se actualizo la lista",
                        icon: "success"
                    });
                },
                error: function (data) {
                    $('#errorGrupo').html(data.responseJSON.message);
                    $('#seccionGrupo').addClass('has-error');
                }
            })
        }
    });
});