<?php

namespace Database\Seeders;

use App\Models\MenuItem;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class MenuSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        MenuItem::create(['name'=>'Inicio','url'=>'inicio','icono'=>'fas fa-home','order'=>1,'tipo_url'=>0,'titulo_pagina'=>'BIENVENID@ AL INTRANET DE','descripcion_pagina'=>'Resumen de información','visible'=>3,'banner_pagina'=>'66d0fc34b596a.jpg']);
        MenuItem::create(['name'=>'Noticias y Anuncios','url'=>'noticias','icono'=>'fab fa-readme','order'=>2,'tipo_url'=>0,'titulo_pagina'=>'Noticias y Anuncios','descripcion_pagina'=>'Información relevante','visible'=>3,'banner_pagina'=>'66d0fc6686fe8.jpg']);
        MenuItem::create(['name'=>'Eventos','url'=>'eventos_registrados','icono'=>'fas fa-calendar-alt','order'=>3,'tipo_url'=>0,'titulo_pagina'=>'Eventos','descripcion_pagina'=>'Eventos relevantes','visible'=>3,'banner_pagina'=>'66d0fc838483f.jpg']);
        
        MenuItem::create(['name'=>'RRHH','url'=>null,'icono'=>'fas fa-users-cog','order'=>4,'tipo_url'=>0,'visible'=>1]);
        MenuItem::create(['name'=>'Directorio Empleados','url'=>'directorio','icono'=>null,'order'=>1,'parent_id'=>4,'tipo_url'=>0,'titulo_pagina'=>'Directorio Empleados','descripcion_pagina'=>'Directorio Empleados','visible'=>1,'banner_pagina'=>'66d0fca89a3fd.jpg']);
        MenuItem::create(['name'=>'Documentos Internos','url'=>'documentos','icono'=>'fas fa-file-archive','order'=>2,'parent_id'=>4,'tipo_url'=>0,'titulo_pagina'=>'Documentos Internos','descripcion_pagina'=>'Registro de documentos con referencia procedimientos, instructivos, estatutos, reglamentos y resoluciones.','visible'=>3, 'banner_pagina'=>'66d0fcccb4ab5.jpg']);
        MenuItem::create(['name'=>'Capacitación','url'=>'capacitacion','icono'=>'fas fa-file-video','order'=>3,'parent_id'=>4,'tipo_url'=>0,'titulo_pagina'=>'Capacitación','descripcion_pagina'=>'Videos de Capacitación para el personal.','visible'=>3, 'banner_pagina'=>'66d0fce26ec54.jpg']);
        
        MenuItem::create(['name'=>'Documentos Generales','url'=>'documentos_generales','icono'=>'fas fa-book','order'=>5,'tipo_url'=>0,'titulo_pagina'=>'Documentos Generales','descripcion_pagina'=>'Registro de documentos con referencia a manuales, formularios, guias, planillas, etc.','visible'=>3, 'banner_pagina'=>'66d0fcf618a17.jpg']);
        MenuItem::create(['name'=>'Social y Comunidad','url'=>'social_comunidad','icono'=>'fas fa-users','order'=>6,'tipo_url'=>0,'titulo_pagina'=>'Social y Comunidad','descripcion_pagina'=>'Galería de fotos y videos de eventos institucionales.','visible'=>3, 'banner_pagina'=>'66d0fd072cf2a.jpg']);
        
        MenuItem::create(['name'=>'Sistema SEDEM','url'=>null,'icono'=>'fas fa-atlas','order'=>7,'tipo_url'=>0,'visible'=>3]);
        MenuItem::create(['name'=>'RRHH, VIATICOS, ACTIVOS FIJOS','url'=>'http://rrhh.sedem.gob.bo/appsedem/','icono'=>null,'order'=>1,'parent_id'=>10,'tipo_url'=>1,'visible'=>3]);
        MenuItem::create(['name'=>'CORBAN','url'=>'https://sigec.sedem.gob.bo/login?url=','icono'=>null,'order'=>2,'parent_id'=>10,'tipo_url'=>1,'visible'=>3]);
        MenuItem::create(['name'=>'EMAIL INSTITUCIONAL','url'=>'https://mail.subsidio.gob.bo/','icono'=>null,'parent_id'=>10,'order'=>3,'tipo_url'=>1,'visible'=>3]);
        MenuItem::create(['name'=>'S.I.S.U.B.','url'=>'http://sistemas.sedem.gob.bo/','icono'=>null,'order'=>4,'parent_id'=>10,'tipo_url'=>1,'visible'=>3]);
        
        MenuItem::create(['name'=>'Sistios Web de Interes','url'=>null,'icono'=>'fas fa-wifi','order'=>8,'tipo_url'=>0,'visible'=>3]);
        MenuItem::create(['name'=>'Ecebol','url'=>'https://www.ecebol.com.bo/','icono'=>null,'order'=>1,'parent_id'=>15,'tipo_url'=>1,'visible'=>3]);
        MenuItem::create(['name'=>'Envibol','url'=>'https://www.envibol.com.bo/','icono'=>null,'order'=>2,'parent_id'=>15,'tipo_url'=>1,'visible'=>3]);
        MenuItem::create(['name'=>'Papelbol','url'=>'https://www.papelbol.com.bo/','icono'=>null,'order'=>3,'parent_id'=>15,'tipo_url'=>1,'visible'=>3]);
        MenuItem::create(['name'=>'EEPAF','url'=>'https://www.eepaf.com.bo/','icono'=>null,'order'=>4,'parent_id'=>15,'tipo_url'=>1,'visible'=>3]);
        MenuItem::create(['name'=>'Cartonbol','url'=>'https://cartonbol.com.bo/','icono'=>null,'order'=>5,'parent_id'=>15,'tipo_url'=>1,'visible'=>3]);
        MenuItem::create(['name'=>'EEPS','url'=>'https://www.eeps.com.bo/','icono'=>null,'order'=>5,'parent_id'=>15,'tipo_url'=>1,'visible'=>3]);
    }
}
