<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('menu_items', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('url')->nullable();
            $table->string('icono')->nullable();
            $table->integer('visible')->nullable()->comment('1 = Solo Intranet SEDEM, 2 = Solo Intranet Unidad, 3=Visible Para Ambos Tipos de intranet');
            $table->integer('order')->default(0);
            $table->boolean('tipo_url')->default(0)->comment('1 = Url Externa, 0 = Url Interna');
            $table->string('titulo_pagina')->nullable()->comment('Solo para menús sin submenus');
            $table->string('descripcion_pagina')->nullable()->comment('Solo para menús sin submenus');
            $table->string('banner_pagina')->nullable()->comment('Es la imagen de fondo que se muestra en la sección del titulo de la página');
            $table->unsignedBigInteger('parent_id')->nullable();
            $table->unsignedBigInteger('created_by')->nullable();
            $table->unsignedBigInteger('updated_by')->nullable();
            $table->unsignedBigInteger('deleted_by')->nullable();
            $table->timestamps();
            $table->softDeletes();
            $table->foreign('parent_id')->references('id')->on('menu_items');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('menu_items');
    }
};
