<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Mapa con Filtros e Íconos</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-sRIl4kxILFvY47J16cr9ZwB07vP4J8+LH7qKQnuqkuIAvNWLzeN8tE5YBujZqJLB" crossorigin="anonymous">
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,600&display=swap" rel="stylesheet" />

        <link rel="icon" href="<?php echo e(asset('favicon.ico')); ?>" type="image/x-icon">
        <link href="https://fonts.googleapis.com/css?family=Lato:300,400,700&display=swap" rel="stylesheet">

        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
        <link rel="stylesheet" href="<?php echo e(asset('assets/fonts/fontawesome.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets_welcome/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/coordenadas.css')); ?>">
 
   <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.4/dist/leaflet.css"/>
   

</head>
<body>
<div class="container-fluid my-3">
    <div class="card shadow-sm">
        <div class="card-header bg-primary text-white p-2">
            <div class="d-flex align-items-center justify-content-between">
                <img src="<?php echo e(asset('img/logo-icono.png')); ?>" alt="" class="img-fluid logo-icon">
                <h3 class="mb-2 mb-md-0 text-white">Ubicaciones por Empresa y Tipo Infraestructura</h3>
                <img src="<?php echo e(asset('img/logo-sedem.png')); ?>" 
                     alt="Logo" 
                     class="img-fluid logo-full"style="max-height:120px;" 
                     >
            </div>
        </div>
        <div class="card-body">
            <form method="GET" action="<?php echo e(route('coordenadas.index')); ?>">
                <div class="row gy-3">

                    <!-- EMPRESA -->
                    <div class="col-sm-12 col-md-4 mb-0">
                        <label for="empresaSelect" class="form-label fw-bold">EMPRESA:</label>
                        <select id="empresaSelect" name="empresa[]" multiple class="form-control form-control">
                            <option value="__ALL__">🌐 Todas las Empresas</option>
                            <?php $__currentLoopData = $empresas; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $e): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($e->empresa); ?>"
                                    <?php if(!empty($empresa) && in_array($e->empresa, $empresa)): ?> selected <?php endif; ?>>
                                    <?php echo e($e->empresa); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- TIPO INFRAESTRUCTURA -->
                    <div class="col-sm-12 col-xs-12 col-md-4 mb-0">
                        <label for="tipoSelect" class="form-label fw-bold">TIPO INFRAESTRUCTURA:</label>
                        <select id="tipoSelect" name="tipo[]" multiple class="form-control form-control">
                            <option value="__ALL__">🏷 Todos los Tipos</option>
                            <?php $__currentLoopData = $tipos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $iconos = [
                                        'PLANTA' => '../icons/planta.png',
                                        'AGENCIA' => '../icons/agencia.png',
                                        'DISTRIBUIDORA' => '../icons/distribuidora.png',
                                        'TERRENO' => '../icons/terreno.png',
                                        'PROYECTO' => '../icons/proyecto.png',
                                    ];
                                    $nombre = $t->tipoinfraestructura;
                                    $icono = $iconos[$nombre] ?? '../icons/default.png';
                                ?>
                                <option value="<?php echo e($nombre); ?>" data-icon="<?php echo e($icono); ?>"
                                    <?php if(!empty($tipo) && in_array($nombre, $tipo)): ?> selected <?php endif; ?>>
                                    <?php echo e($nombre); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </select>
                    </div>

                    <!-- BOTÓN FILTRAR -->
                    <div class="col-sm-12 col-md-4 d-flex align-items-end mb-0 mt-0">
                        <button type="submit" class="btn btn-primary btn-lg w-100">Filtrar</button>
                    </div>

                </div>
            </form>
        </div>
    </div>
</div>



<div id="map" class="map-responsive"></div>

<script src="https://unpkg.com/leaflet@1.9.4/dist/leaflet.js"></script>

<script>
    const datos = <?php echo json_encode($datos, 15, 512) ?>;

    const map = L.map('map').setView([-16.2902, -63.5887], 6);

    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        maxZoom: 18
    }).addTo(map);

    // ---------------------------
    // ÍCONOS PERSONALIZADOS
    // ---------------------------
    const icons = {
        "PLANTA": L.icon({
            iconUrl: '../icons/planta.png',
            iconSize: [50, 50]
        }),
        "AGENCIA": L.icon({
            iconUrl: '../icons/agencia.png',
            iconSize: [50, 50]
        }),
        "DISTRIBUIDORA": L.icon({
            iconUrl: '../icons/distribuidora.png',
            iconSize: [50, 50]
        }),
        "TERRENO": L.icon({
            iconUrl: '../icons/terreno.png',
            iconSize: [50, 50]
        }),
        "PROYECTO": L.icon({
            iconUrl: '../icons/proyecto.png',
            iconSize: [50, 50]
        }),
    };

    // ---------------------------
    // PINTAR MARCADORES
    // ---------------------------
    datos.forEach(item => {

        let lat = parseFloat(item.latitud.replace(',', '.'));
        let lng = parseFloat(item.longitud.replace(',', '.'));

        // Determinar ícono según tipo
        // OJO: aquí debes usar el nombre real que tiene tu tabla
        let tipo = item.tipoinfraestructura;  
        let icono = icons[tipo] ?? icons["PLANTA"];

        L.marker([lat, lng], { icon: icono }).addTo(map)
            .bindPopup(`
                <b>${item.empresa}</b><br>
                Tipo: ${item.tipoinfraestructura}<br>
                Departamento: ${item.departamento}<br>
                Municipio: ${item.municipio}<br>
                Lat: ${lat}<br>
                Lng: ${lng}
            `);
    });
</script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.8/dist/js/bootstrap.bundle.min.js" integrity="sha384-FKyoEForCGlyvwx9Hj09JcYn3nv7wiPVlz7YYwJrWVcXK/BmnVDxM+D2scQbITxI" crossorigin="anonymous"></script>
<script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
    $('#empresaSelect').select2();
    $('#tipoSelect').select2({
        templateResult: formatIcon,
        templateSelection: formatIcon
    });

    function formatIcon(option) {
        if (!option.id) return option.text;
        const icon = $(option.element).data('icon');
        return $(`<span><img src="${icon}" style="width:20px;margin-right:5px;">${option.text}</span>`);
    }

    // lógica de "Todos"
    $('#empresaSelect').on('change', function() {
        if ($(this).val().includes('__ALL__')) {
            $(this).val(['__ALL__']).trigger('change.select2');
        }
    });

    $('#tipoSelect').on('change', function() {
        if ($(this).val().includes('__ALL__')) {
            $(this).val(['__ALL__']).trigger('change.select2');
        }
    });
});

</script>

</body>
</html>
<?php /**PATH /var/www/html/formularios_externos/resources/views/coordenadas.blade.php ENDPATH**/ ?>