
<?php $__env->startSection('title',"Registro"); ?>
<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="page-block">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="page-header-title">
                    <h5 class="m-b-10"><?php echo e($parTipoformulario->nombre); ?></h5>
                </div>
                <ul class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Inicio</a></li>
                    <li class="breadcrumb-item"><?php echo e($parTipoformulario->nombre); ?></li>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-12">
        <div class="card">
            <div class="card-header">
                <h4>REGISTRO DE <?php echo e($parTipoformulario->nombre); ?></h4>
            </div>
            <div class="card-body">
                <?php if($errors->any()): ?>
                    <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
                    <ul class="list-ticked mensaje-error">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li class="text-danger"><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                <?php endif; ?>
                <form action="<?php echo e(route('planillas_tabla.store')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <input type="hidden" name="idpar_tipoformulario" value="<?php echo e($parTipoformulario->idpar_tipoformulario); ?>">
                    <input type="hidden" name="idrep_formularioplanilladato" value="<?php echo e($repFormularioplanilladato->idrep_formularioplanilladato); ?>">
                    <div class="row">
                        <div class="col-md-8">
                            <?php $__currentLoopData = $secciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <h5 class="mb-3"><?php echo e($sec->nombre); ?></h5>
                                    <input type="hidden" name="id_seccion" value="<?php echo e($sec->idrep_formularioseccion); ?>">
                                    <?php $__currentLoopData = $sec->contenido; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $cf): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if($cf->eliminado == false ): ?>
                                            <table class="table table-sm" style="margin: 0;">
                                                <tr>
                                                    <?php if($cf->grupo): ?>
                                                        <td style="width: 20%" class="text-right"><?php echo e($cf->grupo->nombre); ?></td>
                                                        <td style="width: 30%" class="text-right"><?php echo e($cf->item->nombre); ?></td>
                                                    <?php else: ?>
                                                        <td style="width: 50%" colspan="2" class="text-right">
                                                            <?php echo e($cf->item->nombre); ?> 
                                                        </td>
                                                    <?php endif; ?>
                                                    <td style="width: 50%">
                                                        <?php
                                                            $valor = null; // Variable para almacenar el valor por defecto
                                                        ?>

                                                        
                                                        <div class="d-flex align-items-center justify-content-between">
                                                            <?php switch($cf->tipo_campo):
                                                                    case ('correlativo'): ?>
                                                                        <input
                                                                        type="number"
                                                                        name="items[<?php echo e($cf->idrep_formulariocontenido); ?>]"
                                                                        class="form-control <?php echo e($errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : ''); ?>"
                                                                        <?php echo e($i == 0 ? 'autofocus' : ''); ?>

                                                                        value="<?php echo e(old('items.' . $cf->idrep_formulariocontenido, $valor == null ? correlativo($cf->seccion->idpar_tipoformulario,) : $valor)); ?>" readonly>
                                                                    <?php break; ?>
                                                                    <?php case ('date'): ?>
                                                                        <input
                                                                        type="date"
                                                                        name="items[<?php echo e($cf->idrep_formulariocontenido); ?>]"
                                                                        class="form-control <?php echo e($errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : ''); ?>"
                                                                        <?php echo e($i == 0 ? 'autofocus' : ''); ?>

                                                                        value="<?php echo e(old('items.' . $cf->idrep_formulariocontenido, $valor == null ? correlativo($cf->seccion->idpar_tipoformulario,) : $valor)); ?>">
                                                                    <?php break; ?>
                                                                    <?php case ('text'): ?>
                                                                        <input
                                                                        type="text"
                                                                        name="items[<?php echo e($cf->idrep_formulariocontenido); ?>]"
                                                                        class="form-control <?php echo e($errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : ''); ?>"
                                                                        <?php echo e($i == 0 ? 'autofocus' : ''); ?>

                                                                        value="<?php echo e(old('items.' . $cf->idrep_formulariocontenido, $valor)); ?>">
                                                                    <?php break; ?>
                                                                    <?php case ('email'): ?>
                                                                        <input
                                                                        type="email"
                                                                        name="items[<?php echo e($cf->idrep_formulariocontenido); ?>]"
                                                                        class="form-control <?php echo e($errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : ''); ?>"
                                                                        <?php echo e($i == 0 ? 'autofocus' : ''); ?>

                                                                        value="<?php echo e(old('items.' . $cf->idrep_formulariocontenido, $valor)); ?>">
                                                                    <?php break; ?>
                                                                    <?php case ('text_area'): ?>
                                                                        <textarea name="items[<?php echo e($cf->idrep_formulariocontenido); ?>]" id="" cols="30" rows="5"  class="form-control <?php echo e($errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : ''); ?>"
                                                                        <?php echo e($i == 0 ? 'autofocus' : ''); ?>><?php echo e(old('items.' . $cf->idrep_formulariocontenido, $valor)); ?></textarea>
                                                                        <?php break; ?>
                                                                    <?php case ('number'): ?>
                                                                        <input
                                                                        type="number"
                                                                        name="items[<?php echo e($cf->idrep_formulariocontenido); ?>]"
                                                                        class="form-control <?php echo e($errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : ''); ?>"
                                                                        <?php echo e($i == 0 ? 'autofocus' : ''); ?>

                                                                        value="<?php echo e(old('items.' . $cf->idrep_formulariocontenido, $valor)); ?>">
                                                                    <?php break; ?>
                                                                    <?php case ('decimal'): ?>
                                                                        <input
                                                                        type="number"
                                                                        step="0.01"
                                                                        name="items[<?php echo e($cf->idrep_formulariocontenido); ?>]"
                                                                        class="form-control <?php echo e($errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : ''); ?>"
                                                                        <?php echo e($i == 0 ? 'autofocus' : ''); ?>

                                                                        value="<?php echo e(old('items.' . $cf->idrep_formulariocontenido, $valor)); ?>">
                                                                    <?php break; ?>
                                                                    <?php case ('select'): ?>
                                                                        <select name="items[<?php echo e($cf->idrep_formulariocontenido); ?>]" class="form-control <?php echo e($errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : ''); ?>">
                                                                            <option value="">--SELECCIONE--</option>
                                                                            <?php $__currentLoopData = explode(';', $cf->items_lista); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <option value="<?php echo e($item); ?>" <?php echo e(old('items.' . $cf->idrep_formulariocontenido, $valor) == $item ? 'selected' : ''); ?>><?php echo e($item); ?></option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </select>
                                                                    <?php break; ?>
                                                                    <?php case ('bolean'): ?>
                                                                        <?php $__currentLoopData = explode(';', $cf->items_lista); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $opcion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                            <div class="form-check">
                                                                                <input 
                                                                                    type="radio" 
                                                                                    name="items[<?php echo e($cf->idrep_formulariocontenido); ?>]" 
                                                                                    id="opcion_<?php echo e($cf->idrep_formulariocontenido); ?>_<?php echo e($key); ?>" 
                                                                                    class="form-check-input <?php echo e($errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : ''); ?>" 
                                                                                    value="<?php echo e($opcion); ?>" 
                                                                                    <?php echo e(old('items.' . $cf->idrep_formulariocontenido, $valor) == $opcion ? 'checked' : ''); ?>>
                                                                                <label for="opcion_<?php echo e($cf->idrep_formulariocontenido); ?>_<?php echo e($key); ?>" class="form-check-label">
                                                                                    <?php echo e($opcion); ?>

                                                                                </label>
                                                                            </div>
                                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php break; ?>  
                                                                    <?php case ('nombre'): ?>
                                                                        <select name="items[<?php echo e($cf->idrep_formulariocontenido); ?>]" id="nombre_persona" class=" <?php echo e($errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : ''); ?>">
                                                                            <option value="">--SELECCIONE--</option>
                                                                            <?php $__currentLoopData = $nombres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <option value="<?php echo e($item); ?>" <?php echo e(old('items.' . $cf->idrep_formulariocontenido, $valor) == $item ? 'selected' : ''); ?>><?php echo e($item); ?></option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </select>
                                                                        <?php break; ?>
                                                                    <?php case ('cargo'): ?>
                                                                        <select name="items[<?php echo e($cf->idrep_formulariocontenido); ?>]" class="cargo <?php echo e($errors->has('items.'.$cf->idrep_formulariocontenido) ? 'is-invalid' : ''); ?>">
                                                                            <option value="">--SELECCIONE--</option>
                                                                            <?php $__currentLoopData = $cargos; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cargo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                                <option value="<?php echo e($cargo); ?>" <?php echo e(old('items.' . $cf->idrep_formulariocontenido, $valor) == $cargo ? 'selected' : ''); ?>><?php echo e($cargo); ?></option>
                                                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                                        </select>
                                                                        <?php break; ?>
                                                                    <?php case ('calculo'): ?>
                                                                        <input 
                                                                            type="text" 
                                                                            id="calculo_<?php echo e($cf->idrep_formulariocontenido); ?>" 
                                                                            name="items[<?php echo e($cf->idrep_formulariocontenido); ?>]" 
                                                                            class="form-control calculo" 
                                                                            readonly 
                                                                            data-formula="<?php echo e($cf->item_formula); ?>" >
                                                                    <?php break; ?> 
                                                            
                                                            <?php endswitch; ?>
                                                            &nbsp;&nbsp;<?php if($cf->idpar_unidadmedida != null): ?> <strong class="text-primary">(<?php echo e($cf->unidad_medida->simbolo); ?>)</strong> <?php endif; ?>
                                                        </div>
                                                    </td>
                                                </tr>
                                            </table>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                    
                    <div class="text-center">
                        <button class="btn btn-primary" type="submit" onclick="return confirm('¿Desea guardar?')">Registrar</button>
                        <a href="<?php echo e(route('planillas.index',$parTipoformulario->idpar_tipoformulario)); ?>" class="btn btn-warning">Terminar y Salir</a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php if($datosVista != null): ?>
<div class="row">
    <div class="col-sm-12">
        <div class="card">
            <div class="card-body">
                <table class="table table-hover table-sm">
                    <thead>
                        <tr>
                            <th class="text-center">Acciones</th>
                            <th class="text-center">Nro.</th>
                            <?php $__currentLoopData = $cabecera; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <th class="text-center"><?php echo e($sec->item); ?></th>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $datosVista; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $registro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($registro['nro_item'] != null): ?>
                                <tr>
                                    <td class="text-center">
                                        <button 
                                            class="btn mr-2 text-danger pl-2 pr-2 delete-btn"
                                            
                                            data-name="<?php echo e($registro['nro_item']); ?>"
                                            data-ruta="<?php echo e(route('registro.destroy',[$registro['idPlanilla'],$registro['nro_item'],$registro['seccion']] )); ?>"
                                            title="Eliminar registro"
                                        >
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </td>
                                    <td class="text-center">
                                        <?php echo e($registro['nro_item']); ?>

                                    </td>
                                    <?php $__currentLoopData = $cabecera; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <td class="text-center">
                                            <?php echo e($registro['valores'][$sec->cont] ?? '-'); ?>

                                        </td>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tr>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
<form id="delete-form" method="POST" style="display:none;">
    <?php echo csrf_field(); ?>
    <?php echo method_field('DELETE'); ?>
</form>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script>
        $('#nombre_persona').select2({
            width: '100%'
        });
        $('.cargo').select2({
            width: '100%'
        });
        document.addEventListener('DOMContentLoaded', function () {
        // Manejador del botón eliminar
        updateCalculos();
        // Escucha cambios en los campos numéricos
        document.querySelectorAll('.campo_calculo').forEach(input => {
            input.addEventListener('input', updateCalculos);
        });

        function updateCalculos() {
            // Itera sobre todos los campos de cálculo
            document.querySelectorAll('.calculo').forEach(campoCalculo => {
                const formula = campoCalculo.dataset.formula; // Obtiene la fórmula
                let resultado = formula;
                console.log(resultado);

                // Reemplaza los IDs prefijados con "c" en la fórmula con los valores actuales
                document.querySelectorAll('.campo_calculo').forEach(campo => {
                    const id = campo.dataset.id; // Obtiene el "cID"
                    const valor = parseFloat(campo.value) || 0; // Valor o 0 si está vacío
                    resultado = resultado.replace(new RegExp(`\\b${id}\\b`, 'g'), valor);
                    console.log(id,valor,resultado);
                });

                try {
                    // Evalúa la fórmula y actualiza el campo de cálculo
                    campoCalculo.value = eval(resultado).toFixed(2);
                } catch (e) {
                    campoCalculo.value = "Error";
                }
            });
        }
        document.querySelectorAll('.delete-btn').forEach(button => {
            button.addEventListener('click', function () {
                const itemName = this.dataset.name;
                const url=this.dataset.ruta
                // SweetAlert para confirmar eliminación
                Swal.fire({
                    title: `¿Está seguro de eliminar el registro "${itemName}"?`,
                    text: "Esta acción no se puede deshacer.",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Sí, eliminar',
                    cancelButtonText: 'Cancelar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Enviar solicitud de eliminación
                        const form = document.getElementById('delete-form');
                        form.action = url;
                        form.submit();
                    }
                });
            });
        });
    });
    </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/formularios_externos/resources/views/registro/create_tabla.blade.php ENDPATH**/ ?>