
<?php $__env->startSection('title','Gestión de Perfiles y Permisos'); ?>
<?php $__env->startSection('content'); ?>
<div class="page-header">
    <div class="page-block">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="page-header-title">
                    <h5 class="m-b-10">Gestión de Perfiles y Permisos</h5>
                </div>
                <ul class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Inicio</a></li>
                    <li class="breadcrumb-item">Perfiles</li>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-12">
        <div class="card">
            <div class="card-body">
                <form action="<?php echo e(route('perfil.permisos.guardar')); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                
                    <div class="row">
                        <label for="rol" class="form-label col-md-4 text-md-right">Selecciona un perfil:</label>
                        <div class="col-md-8">
                            <select name="rol" id="rol" class="form-control">
                                <option value="">-- Selecciona --</option>
                                <?php $__currentLoopData = $perfiles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rol): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($rol->name); ?>"><?php echo e($rol->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>
                    </div>
                
                    <div id="tablaPermisos" style="display: none; margin-top: 20px;">
                        <div class="d-flex align-items-center justify-content-between" >
                            <h3 id="tituloRol"></h3>
                            <div>
                                <button type="button" id="seleccionar-todos" class="btn btn-warning">Seleccionar todos</button>
                                <button type="button" id="deseleccionar-todos" class="btn btn-secondary">Deseleccionar todos</button>
                            </div>
                        </div>
                        <br>
                        <table  cellpadding="6" cellspacing="0" class="table table-hover table-sm table-bordered">
                            <thead>
                                <tr>
                                    <th class="text-center">Formulario</th>
                                    <th class="text-center">Registrar</th>
                                    <th class="text-center">Editar</th>
                                    <th class="text-center">Eliminar</th>
                                    <th class="text-center">Aprobar</th>
                                    <th class="text-center">Visualización</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $formularios; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $formulario): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($formulario->nombre); ?></td>
                                        <?php $__currentLoopData = ['registrar', 'editar', 'eliminar', 'aprobar','ver']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $accion): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <td style="text-align:center;">
                                                <input type="checkbox"
                                                    name="permisos[<?php echo e($formulario->idpar_tipoformulario); ?>][<?php echo e($accion); ?>]"
                                                    value="1"
                                                    class="permiso-checkbox"
                                                    data-permiso="<?php echo e($accion . '_formulario_' . $formulario->idpar_tipoformulario); ?>">
                                            </td>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                
                        <input type="hidden" name="rolSeleccionado" id="rolSeleccionado">
                        <div class="text-center">
                            <button type="submit" style="margin-top: 10px;" class="btn btn-primary">Guardar permisos</button>
                            
                        </div>
                    </div>
                </form>
                
            </div>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
<script>
    document.getElementById('rol').addEventListener('change', function () {
        const rol = this.value;

        if (!rol) {
            document.getElementById('tablaPermisos').style.display = 'none';
            return;
        }

        fetch(url_global + `/admin/permisos_formulario?rol=${rol}`)
            .then(response => response.json())
            .then(permisos => {
                // Desmarca todos primero
                document.querySelectorAll('.permiso-checkbox').forEach(checkbox => {
                    checkbox.checked = false;
                });

                // Marca los permisos que tiene el rol
                permisos.forEach(nombre => {
                    const checkbox = document.querySelector(`.permiso-checkbox[data-permiso="${nombre}"]`);
                    if (checkbox) {
                        checkbox.checked = true;
                    }
                });

                document.getElementById('rolSeleccionado').value = rol;
                document.getElementById('tituloRol').innerText = `Permisos asignados a: ${rol}`;
                document.getElementById('tablaPermisos').style.display = 'block';
            });
    });
    $('#seleccionar-todos').on('click', function () {
        $('.permiso-checkbox').prop('checked', true);
    });

    $('#deseleccionar-todos').on('click', function () {
        $('.permiso-checkbox').prop('checked', false);
    });

</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/formularios_externos/resources/views/admin/perfiles-permisos/index.blade.php ENDPATH**/ ?>