<?php $__env->startSection('title','Generar Formulario'); ?>
<?php $__env->startSection('content'); ?>
<style> 
    .table td, .table th {
    border-top: 1px solid #f1f1f1;
    white-space: wrap;
    /* padding: 0.7rem 0.75rem; */
}
</style>
<div class="page-header">
    <div class="page-block">
        <div class="row align-items-center">
            <div class="col-md-6">
                <div class="page-header-title">
                    <h5 class="m-b-10">Formularios</h5>
                </div>
                <ul class="breadcrumb">
                    <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Inicio</a></li>
                    <li class="breadcrumb-item">Secciones Formulario</li>
                </ul>
            </div>
        </div>
    </div>
</div>
<div class="row">
    <div class="col-sm-12">
        <div class="card">
            <div class="card-header">
                <div class="d-flex align-items-center justify-content-between">
                    <h4>Secciones creadas por formulario</h4>
                    <div>
                        <a href="javascript:void(0);" class="btn btn-primary" onclick="createContent();" >Nuevo Contenido</a>
                    </div>
                </div>
            </div>
            
            <div class="card-body">
                <ul class="nav nav-tabs mb-3" id="myTab" role="tablist">
                    <?php $__currentLoopData = $formularios_secciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$form): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $puedeVer = auth()->user()->can('ver_formulario_' . $form->idpar_tipoformulario);
                        ?>
                        <?php if($form->formulario != null && $puedeVer): ?>
                            <li class="nav-item">
                                <a class="nav-link <?php echo e($activo_id==null && $key == 0 ? ' show active' : ($form->idpar_tipoformulario == $activo_id ? 'show active' : '')); ?>" data-toggle="tab" href="#form<?php echo e($form->idpar_tipoformulario); ?>" role="tab" aria-controls="home" aria-selected="true"><?php echo e($form->formulario->nombre); ?></a>
                            </li>
                        <?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
                <div class="table-responsive">
                    <div class="tab-content" id="myTabContent">
                        <?php $__currentLoopData = $formularios_secciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $f): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php
                                $visualizar = auth()->user()->can('ver_formulario_' . $f->idpar_tipoformulario);
                            ?>
                            <?php if($visualizar): ?>
                                <div class="tab-pane fade <?php echo e($activo_id==null && $k == 0 ? 'show active' : ($f->idpar_tipoformulario == $activo_id ? 'show active' : '')); ?>" id="form<?php echo e($f->idpar_tipoformulario); ?>" role="tabpanel" aria-labelledby="<?php echo e($f->idpar_tipoformulario); ?>-f">
                                    <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tipo_formulario.show')): ?><div class="text-right"><a href="<?php echo e(route('planillas.show',$f->formulario->idpar_tipoformulario)); ?>" class="btn btn-success" target="_blank">Ver Formulario</a></div><?php endif; ?>
                                    <table class="table table-sm table-hover" id="datos">
                                        <thead>
                                            <tr>
                                                <th class="text-center col-1">Acciones</th>
                                                <th class="text-center col-1">Posición</th>
                                                <th class="text-center col-3">Sección Nombre</th>
                                                <th class="text-center col-7">Variables</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $secciones; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <?php if($s->idpar_tipoformulario == $f->idpar_tipoformulario): ?>
                                                    <tr>
                                                        <td>
                                                            <div class="d-flex align-items-center justify-content-center">
                                                                <a href="javascript:void(0);" class="mr-3" title="Modificar datos" onclick="editContent(<?php echo e($s->idrep_formularioseccion); ?>,'<?php echo e($s->nombre); ?>','<?php echo e($s->formulario->idpar_tipoformulario); ?>',<?php echo e($s->orden); ?>)"><i class="fas fa-edit"></i></a>
                                                                <button 
                                                                    class="btn mr-2 text-danger pl-2 pr-2 mr-3 delete-btn"
                                                                    data-id="<?php echo e($s->idrep_formularioseccion); ?>"
                                                                    data-name=<?php echo e($s->nombre); ?> 
                                                                    data-ruta="<?php echo e(route('secciones.destroy',$s->idrep_formularioseccion )); ?>"
                                                                    title="Eliminar sección"
                                                                >
                                                                    <i class="fas fa-trash"></i>
                                                                </button>
                                                                <a href="javascript:void(0);" class="text-success mr-3" title="Agregar Campos" onclick="create(<?php echo e($s->idrep_formularioseccion); ?>)"><i class="fas fa-plus"></i></a>
                                                                <a href="javascript:void(0);" class="text-info" title="Agregar Campo con formula" onclick="itemFormula(<?php echo e($s); ?>)"><i class="fas fa-percent"></i></a>
                                                            </div>
                                                        </td>
                                                        <td class="text-center"><h3><span class="badge badge-secondary"><?php echo e($s->orden); ?></span></h3></td>
                                                        <td class="text-center"><?php echo e($s->nombre); ?></td>
                                                        <td class="text-left p-0">
                                                            <table class="m-0" width="100%">
                                                                <tr>
                                                                    <th class="text-center col-1">Acciones</th>
                                                                    <th class="text-center col-1">Posición</th>
                                                                    <th class="text-center col-2">Grupo</th>
                                                                    <th class="text-center col-8">Nombre del Campo</th>
                                                                </tr>
                                                                <?php $__currentLoopData = $s->contenido; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                                    <?php if($i->eliminado == false): ?>
                                                                    <tr>
                                                                        <td>
                                                                            <div class="d-flex align-items-center justify-content-center">
                                                                                <?php if($i->tipo_campo != 'calculo'): ?>
                                                                                    <a href="javascript:void(0);" class="mr-3" title="Modificar datos" onclick="editarItem(<?php echo e($i); ?>)" ><i class="fas fa-edit"></i></a>
                                                                                <?php else: ?>
                                                                                    <a href="javascript:void(0);" class="mr-3" title="Modificar datos" onclick="editarItemCalculo(<?php echo e($i); ?>)" ><i class="fas fa-edit"></i></a>
                                                                                <?php endif; ?>
                                                                                <button 
                                                                                    class="btn mr-2 text-danger pl-2 pr-2 mr-3 delete-item-btn"
                                                                                    
                                                                                    data-name="<?php echo e($i->item->nombre); ?>"
                                                                                    data-ruta="<?php echo e(route('campo.destroy',$i->idrep_formulariocontenido )); ?>"
                                                                                    title="Eliminar campo"
                                                                                >
                                                                                    <i class="fas fa-trash"></i>
                                                                                </button>
                                                                            </div>
                                                                        </td>
                                                                        <td class="text-center"><h4><span class="badge badge-secondary"><?php echo e($i->orden_item); ?></span></h4></td>
                                                                        <td class="text-left"><?php echo e($i->grupo != null ? $i->grupo->nombre : ''); ?></td>
                                                                        <td class="text-left"><?php echo e($i->item->nombre); ?> <?php if($i->idpar_unidadmedida != NULL ): ?> (<?php echo e($i->unidad_medida->nombre); ?>) <?php endif; ?> <br> Tipo Campo: <?php echo e($i->tipo_campo); ?> <?php if($i->obligatorio == true): ?> <br> Obligatorio <?php endif; ?></td>
                                                                    </tr>
                                                                    <?php endif; ?>
                                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                            </table>
                                                        </td>
                                                    </tr>
                                                <?php endif; ?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<form id="delete-form" method="POST" style="display:none;">
    <?php echo csrf_field(); ?>
    <?php echo method_field('DELETE'); ?>
</form>
<form id="delete-item-form" method="POST" style="display:none;">
    <?php echo csrf_field(); ?>
    <?php echo method_field('DELETE'); ?>
</form>
<?php echo $__env->make('secciones.modals.item', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('secciones.modals.seccion', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('secciones.modals.item_calculo', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            <?php if($errors->any()): ?>
                var myModal = new bootstrap.Modal(document.getElementById('modalSeccion'));
                myModal.show();
            <?php endif; ?>
            <?php if($errors->errorItem->any()): ?>
                var myModal = new bootstrap.Modal(document.getElementById('modalItem'));
                myModal.show();
            <?php endif; ?>
            <?php if($errors->errorItemCalculo->any()): ?>
                var myModal = new bootstrap.Modal(document.getElementById('itemCalculoModal'));
                myModal.show();
            <?php endif; ?>

            const modal = document.getElementById('modalItem');
            const formulario = document.getElementById('formItem');

            modal.addEventListener('hidden.bs.modal', function () {
                // Limpiar todos los campos del formulario
                formulario.reset();
            });
        });
        // Referencia al input de fórmula
        const formulaInput = document.getElementById('formula');

        // Función para agregar operadores a la fórmula
        function agregarOperador(operador) {
            formulaInput.value += ` ${operador} `;
        }

        // Función para agregar campos seleccionados a la fórmula
        function agregarCampo() {
            const campoSelect = document.getElementById('campos');
            const campoSeleccionado = campoSelect.value;

            if (campoSeleccionado) {
                formulaInput.value += ` c${campoSeleccionado} `;
                campoSelect.selectedIndex = 0; // Reinicia el dropdown
            } else {
                alert('Por favor, selecciona un campo antes de agregarlo.');
            }
        }
        let editor;
        document.querySelectorAll('#valor_predeterminado').forEach((textarea) => {
        ClassicEditor
            .create(textarea)
            .then(editorInstance => {
                editor = editorInstance;
            })
            .catch(error => console.error(error));
    });
    </script>
    <script src="<?php echo e(asset('assets/js/pages/items.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/formularios_externos/resources/views/secciones/index.blade.php ENDPATH**/ ?>