<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1">

        <title>ENCUESTAS Y FORMULARIOS SEDEM Y EPPS</title>

        <!-- Fonts -->
        <link rel="preconnect" href="https://fonts.bunny.net">
        <link href="https://fonts.bunny.net/css?family=figtree:400,600&display=swap" rel="stylesheet" />

        <link rel="icon" href="<?php echo e(asset('favicon.ico')); ?>" type="image/x-icon">
        <link href="https://fonts.googleapis.com/css?family=Lato:300,400,700&display=swap" rel="stylesheet">

        <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/font-awesome/4.7.0/css/font-awesome.min.css">
        <link rel="stylesheet" href="<?php echo e(asset('assets/fonts/fontawesome.css')); ?>">
        <link rel="stylesheet" href="<?php echo e(asset('assets_welcome/css/style.css')); ?>">
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>


    </head>
    <body style="background-image: url(<?php echo e(asset('img/'.$parTipoformulario->fondo)); ?>); 
    background-size: 100% auto;  
    background-repeat: no-repeat; 
    background-attachment: fixed;
    background-position: center bottom; background-color: <?php echo e($parTipoformulario->color_fondo); ?>">
        <section class="ftco-section">
            <div class="container">
                <div class="d-flex align-items-center justify-content-end">
                    <?php if(auth()->guard()->check()): ?>
                    <a href="<?php echo e(route('home')); ?>" class="" title="Ir al Inicio"><i class="fas fa-home"></i></a>
                    <?php else: ?>
                        <a href="<?php echo e(route('login')); ?>" class="" title="Iniciar Sesión"><i class="fas fa-door-open"></i></a>
                    <?php endif; ?>
                </div>
                <div class="row justify-content-center">
                    <div class="col-md-10 col-lg-10">
                        <div class="login-wrap pr-4 pl-4 pt-0 pb-0 p-md-5">
                            <div class="row">
                                <div class="col-md-4">
                                    <img src="<?php echo e(asset('img/'.$parTipoformulario->logo)); ?>" class="" style="width: 150px;">
                                </div>
                                <div class="col-md-8">
                                    <div class="text-center">
                                        <h3 style="color:<?php echo e($parTipoformulario->color_titulo); ?>;"><?php echo e($parTipoformulario->tipo); ?> </h3>
                                        <h3 style="color:<?php echo e($parTipoformulario->color_subtitulo); ?>;"><?php echo nl2br($parTipoformulario->descripcion); ?></h3>
                                    </div>
                                </div>
                            </div>
                            <?php if($errors->any()): ?>
                                <h5 class="text-danger">ERRORES POR CORREGIR:</h5>
                                <ul class="list-ticked mensaje-error">
                                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li class="text-danger"><?php echo e($error); ?></li>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            <?php endif; ?>
                            <?php echo $__env->make('sweetalert::alert', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            <form action="<?php echo e(route('planillas.store')); ?>" method="POST" id="formData" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <?php echo $__env->make('registro._form_welcome',['submitButtonText' => 'Registrar','tipo'=>1,'origen'=>'externo'], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        <script>
            document.querySelectorAll('.confirm-btn').forEach(button => {
            button.addEventListener('click', function () {
                const itemName = this.dataset.name;
                const url=this.dataset.ruta
                // SweetAlert para confirmar eliminación
                Swal.fire({
                    title: `¿Verifico los datos ingresados?`,
                    text: "Una vez registrado ya no se puede modificar.",
                    icon: "warning",
                    showCancelButton: true,
                    confirmButtonColor: '#d33',
                    cancelButtonColor: '#3085d6',
                    confirmButtonText: 'Sí, registrar',
                    cancelButtonText: 'Cancelar'
                }).then((result) => {
                    if (result.isConfirmed) {
                        // Enviar solicitud de eliminación
                        const form = document.getElementById('formData');
                        form.action = url;
                        form.submit();
                    }
                });
            });
        });
        </script>
    </body>
</html>
<?php /**PATH /var/www/html/formularios_externos/resources/views/welcome.blade.php ENDPATH**/ ?>