<!DOCTYPE html>
<html lang="es">

<head>

    <title><?php echo e(config('app.name')); ?></title>
    <!-- HTML5 Shim and Respond.js IE11 support of HTML5 elements and media queries -->
    <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
    <!--[if lt IE 11]>
  <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
  <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
  <![endif]-->
    <!-- Meta -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="description" content="" />
    <meta name="keywords" content="">
    <meta name="author" content="Phoenixcoded" />

    <!-- Favicon icon -->
    <link rel="icon" href="<?php echo e(asset('assets/images/favicon.svg')); ?>" type="image/x-icon">

    <!-- font css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/fonts/font-awsome-pro/css/pro.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/fonts/feather.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/fonts/fontawesome.css')); ?>">

    <!-- vendor css -->
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/customizer.css')); ?>">


</head>

<!-- [ auth-signin ] start -->
<div class="auth-wrapper">
    <div class="auth-content">
        <div class="card">
            <div class="row align-items-center text-center">
                <div class="col-md-12">
                    <div class="card-body">
                        <h1>Free DynaForms</h1>
                        <h4 class="mb-3 f-w-400">Ingresar con sus credenciales</h4>
                        <?php if($errors->any()): ?>
                            <ul style="list-style: none; " class="alert-danger">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li class="text-danger"><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        <?php endif; ?>
                        <form method="POST" action="<?php echo e(route('login')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="input-group mb-3">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i data-feather="user"></i></span>
                                </div>
                                <input type="text" name="username" class="form-control"
                                    placeholder="Nombre de Usuario">
                            </div>
                            <div class="input-group mb-4">
                                <div class="input-group-prepend">
                                    <span class="input-group-text"><i data-feather="lock"></i></span>
                                </div>
                                <input type="password" name="password" class="form-control" placeholder="Contraseña">
                            </div>
                            <div class="d-flex justify-content-center">
                                <div class="captcha-container mb-0">
                                    <img src="<?php echo e(captcha_src('large')); ?>" alt="captcha" class="captcha-img" id="captcha-image">
                                    <button type="button" class="btn btn-danger btn-refresh-captcha" id="refresh-captcha" title="">
                                        ↻
                                    </button>
                                </div>
                            </div>
                            <div class="input-group ">
                                <input id="captcha" type="text" class="form-control <?php $__errorArgs = ['captcha'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"  placeholder="Ingrese el texto captcha"
                                    name="captcha"  autocomplete="off">
                            </div>
                            <button class="btn btn-block btn-success mb-4" type="submit">Ingresar</button>
                            
                            
                            
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- [ auth-signin ] end -->

<!-- Required Js -->
<script src="<?php echo e(asset('assets/js/vendor-all.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/bootstrap.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/plugins/feather.min.js')); ?>"></script>
<script src="<?php echo e(asset('assets/js/pcoded.min.js')); ?>"></script>
  <script>
    document.addEventListener('DOMContentLoaded', function() {
    document.getElementById('refresh-captcha').addEventListener('click', function() {
        // Añadimos un parámetro aleatorio para evitar el caché
        document.getElementById('captcha-image').src = '<?php echo e(captcha_src('large')); ?>?' + Math.random();
    });
});
    </script>


</body>

</html>
<?php /**PATH /var/www/html/formularios_externos/resources/views/auth/login.blade.php ENDPATH**/ ?>