<?php $__env->startSection('title','Tipo de Formulario'); ?>
<?php $__env->startSection('content'); ?>
<div class="page-header">
  <div class="page-block">
      <div class="row align-items-center">
          <div class="col-md-6">
              <div class="page-header-title">
                  <h5 class="m-b-10">TIPOS DE FORMULARIO</h5>
              </div>
              <ul class="breadcrumb">
                  <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Inicio</a></li>
                  <li class="breadcrumb-item">Tipo de Formulario</li>
              </ul>
          </div>
      </div>
  </div>
</div>
      <!-- [ Main Content ] start -->
      <div class="row">
        <!-- [ sample-page ] start -->
        <div class="col-sm-12">
          <div class="card">
            <div class="card-header">
              <div class="d-flex align-items-center justify-content-between">
                <h4>Tipos de formularios registrados</h4>
                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tipo_formulario.create')): ?>
                  <a href="<?php echo e(route('tipo_formulario.create')); ?>" class="btn btn-primary" onclick="create();">Nuevo Formulario</a>
                <?php endif; ?>
              </div>
            </div>
            <div class="card-body"> 
                <div class="table-responsive">
                    <table class="table table-inverse table-sm" id="datos" style="width: 100%;">
                        <thead>
                            <tr>
                                <th class="text-center">Acciones</th>
                                <th class="text-center">Tipo</th>
                                <th class="text-center">Estado </th>
                                <th class="text-center">Fecha inicio publicación </th>
                                <th class="text-center">Fecha fin publicación </th>
                                <th class="text-center">URL</th>
                                <th class="text-center">Nombre formulario</th>
                                <th class="text-center">Descripción formulario</th>
                                <th class="text-center">Descripción aclarando campo obligatorio </th>
                                <th class="text-center">Mensaje formulario llenado </th>
                                <th class="text-center">Mensaje formulario deshabilitado </th>
                                <th class="text-center">Código</th>
                                <th class="text-center">Formato <br>Impresion</th>
                                <th class="text-center">Logo</th>
                                <th class="text-center">Fondo </th>
                                <th class="text-center">Color Fondo </th>
                                <th class="text-center">Color Texto Campos </th>
                                <th class="text-center">Color Titulo </th>
                                <th class="text-center">Color Subtitulo </th>
                            </tr>
                        </thead>
                        <tbody>
                          <?php $__currentLoopData = $tipos_formulario; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tipo): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                              <td class="d-flex flex-column align-items-center justify-content-center">
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tipo_formulario.edit')): ?>
                                  <a href="<?php echo e(route('tipo_formulario.edit', $tipo->idpar_tipoformulario)); ?>" class="m-1" title="Modificar datos tipo formulario" ><i class="fa fa-edit"></i></a>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tipo_formulario.destroy')): ?>
                                  <a href="javascript:void(0)" type="button" class="btnDelete text-danger m-1" data-id="' + fila.idpar_tipoformulario + '" data-name="'+fila.nombre+'" title="Eliminar tipo formulario"><i class="fa fa-trash"></i></a>
                                <?php endif; ?>
                                <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('tipo_formulario.create')): ?>
                                  <a href="javascript:void(0)" type="button" class="btnPublicar m-1 text-success"  data-id="<?php echo e($tipo->idpar_tipoformulario); ?>" data-estado="<?php echo e($tipo->estado); ?>"  title="Publicar tipo formulario" ><i class="fas fa-cloud-upload-alt"></i></a>
                                <?php endif; ?>
                              </td>
                              <td><?php echo e($tipo->tipo); ?></td>
                              <td> <?php if($tipo->estado == 1): ?> <span class="badge badge-success">Publicado</span> <?php else: ?> <span class="badge badge-danger">No publicado</span> <?php endif; ?></td>
                              <td><?php echo e($tipo->fecha_inicio); ?></td>
                              <td><?php echo e($tipo->fecha_fin); ?></td>
                              <td><?php echo e($tipo->slug); ?></td>
                              <td><?php echo e($tipo->nombre); ?></td>
                              <td><?php echo e($tipo->descripcion); ?></td>
                              <td><?php echo e($tipo->descripcion_campo_obligatorio); ?></td>
                              <td><?php echo e($tipo->mensaje_de_llenado_formulario); ?></td>
                              <td><?php echo e($tipo->mensaje_de_formulario_deshabilitado); ?></td>
                              <td><?php echo e($tipo->codigo); ?></td>
                              <td><?php echo e($tipo->formato_impresion); ?></td>
                              <td> <img src="<?php echo e(asset('img/' . $tipo->logo)); ?>" alt="" style="width:100px;"></td>
                              <td> <img src="<?php echo e(asset('img/' . $tipo->fondo)); ?>" alt="" style="width:100px;"> </td>
                              <td style="background-color: <?php echo e($tipo->color_fondo); ?>;" ><?php echo e($tipo->color_fondo); ?></td>
                              <td style="background-color: <?php echo e($tipo->color_texto); ?>;"> <?php echo e($tipo->color_texto); ?></td>
                              <td style="background-color: <?php echo e($tipo->color_titulo); ?>;" ><?php echo e($tipo->color_titulo); ?></td>
                              <td style="background-color: <?php echo e($tipo->color_subtitulo); ?>;"><?php echo e($tipo->color_subtitulo); ?></td>
                            </tr>
                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
          </div>
        </div>
        <!-- [ sample-page ] end -->
      </div>
      <!-- [ Main Content ] end -->
    </div>
  </div>
<?php echo $__env->make('tipo_formulario._modal', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php echo $__env->make('tipo_formulario._estado', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/moment@2.29.4/moment.min.js"></script>
    <script src="<?php echo e(asset('assets/js/pages/crudTipoFormulario.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/pages/estadoTipoFormulario.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/html/formularios_externos/resources/views/tipo_formulario/index.blade.php ENDPATH**/ ?>